local drawing = require("utils.drawing")
local utils = require("utils")

local ball = {}
ball.name = "EvaHelper/DiscoBall"
ball.depth = 0
ball.placements = {
	{
		name = "Disco Ball",
		data = {
			radius = 40,
			arcsX = 10,
			arcsY = 7,
			rotateSpeed = 1,
			type = "Default",
			alphaCircle = 1,
			alphaVertices = 0.7,
			alphaFaces = 0.4,
			showVertices = true,
			showFaces = true
		}
	},
	{
		name = "Disco Ball (dark)",
		data = {
			radius = 40,
			arcsX = 10,
			arcsY = 7,
			rotateSpeed = 1,
			type = "Default",
			alphaCircle = 0.5,
			alphaVertices = 0.2,
			alphaFaces = 0,
			showVertices = true,
			showFaces = false
		}
	}
}

ball.fieldInformation = {
	arcsX = { fieldType = "integer", minimumValue = 1 },
	arcsY = { fieldType = "integer", minimumValue = 1 },
}

function ball.selection(room, entity)
	local x, y, radius = entity.x or 0, entity.y or 0, entity.radius or 40
	return utils.rectangle(x - radius, y - radius, 2 * radius, 2 * radius)
end

function ball.draw(room, entity)
	local x, y = entity.x or 0, entity.y or 0
	local radius, arcsX, arcsY = entity.radius or 40, entity.arcsX or 10, entity.arcsY or 7

	local r, g, b, a = love.graphics.getColor()

	love.graphics.setColor(1.0, 1.0, 1.0, 0.2)
	love.graphics.circle("line", x, y, radius)

	for i = 1, arcsX / 2 do
		love.graphics.line(x, y - radius, x - radius + 4 * i * radius / arcsX, y)
		love.graphics.line(x, y + radius, x - radius + 4 * i * radius / arcsX, y)
	end
	for i = 1, arcsY - 1 do
		love.graphics.line(x - radius, y, x, y - radius + 2 * radius * i / arcsY)
		love.graphics.line(x + radius, y, x, y - radius + 2 * radius * i / arcsY)
	end

	-- reset color
	love.graphics.setColor(r, g, b, a)
end

return ball
