local helpers = require("mods").requireFromPlugin("helpers")

local springDepth = -8501
local springTexture = "objects/spring/00"

--- @type EntityHandler<Entity>
local springUp = {}

springUp.name = "GlacierHelper/PositionSpringUp"
springUp.depth = springDepth
springUp.justification = {0.5, 1.0}
springUp.texture = springTexture
springUp.placements = {
    name = "up",
    data = {
        playerCanUse = true,
        offset = 0,
        freeze = 0.05,
    }
}

function springUp.rotate(room, entity, direction)
    if direction > 0 then
        entity._name = "GlacierHelper/PositionSpringRight"

    else
        entity._name = "GlacierHelper/PositionSpringLeft"
    end

    return true
end

--- @type EntityHandler<Entity>
local springRight = {}

springRight.name = "GlacierHelper/PositionSpringRight"
springRight.depth = springDepth
springRight.justification = {0.5, 1.0}
springRight.texture = springTexture
springRight.rotation = math.pi / 2
springRight.placements = {
    name = "right",
    data = {
        playerCanUse = true,
        offset = 0,
        freeze = 0.05,
    }
}

function springRight.flip(room, entity, horizontal, vertical)
    if horizontal then
        entity._name = "GlacierHelper/PositionSpringLeft"
    end

    return horizontal
end

function springRight.rotate(room, entity, direction)
    if direction < 0 then
        entity._name = "GlacierHelper/PositionSpringUp"
    end

    return direction < 0
end

--- @type EntityHandler<Entity>
local springLeft = {}

springLeft.name = "GlacierHelper/PositionSpringLeft"
springLeft.depth = springDepth
springLeft.justification = {0.5, 1.0}
springLeft.texture = springTexture
springLeft.rotation = -math.pi / 2
springLeft.placements = {
    name = "left",
    data = {
        playerCanUse = true,
        offset = 0,
        freeze = 0.05,
    }
}

function springLeft.flip(room, entity, horizontal, vertical)
    if horizontal then
        entity._name = "GlacierHelper/PositionSpringRight"
    end

    return horizontal
end

function springLeft.rotate(room, entity, direction)
    if direction > 0 then
        entity._name = "GlacierHelper/PositionSpringUp"
    end

    return direction > 0
end

return {
    helpers.withVersion("1", springUp),
    helpers.withVersion("1", springRight),
    helpers.withVersion("1", springLeft)
}
