local vector2 = require("#microsoft.xna.framework.vector2")
local monocle = require("#monocle")
local celeste = require("#celeste")
local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper

function dash(xVector,yVector)
 player.OverrideDashDirection = vector2(xVector, yVector)
 helpers.setPlayerState(2)
 player:StartDash()
 wait(0.25)
 helpers.setPlayerState(11)
 player.OverrideDashDirection = nil
end

local function makeCoroutine(func)
  return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

local coroutineEntity = monocle.Entity()
local dash2

function onBegin()
  player.ForceCameraUpdate = true
  walkTo(-8542)
  wait(10)
  walkTo(-8552)
  wait(1)
  runTo(-8524)
  wait(1)
  walk(6)
  wait(0.1)
  walk(-20,true,2)
  wait(0.5)
  wait(2.5)
  walk(-5)
  wait(0.7)
  run(-20,true)
  getLevel():add(coroutineEntity)
  coroutineEntity:add(jump(0.5))
  run(-50,true)
  dash(-1,0)
  run(-50)
  coroutineEntity:add(jump(1))
  walk(-100,false,2)
  dash(-0.8,0.8)
  walk(-200,false,2)
  coroutineEntity:add(jump(0.5))
  run(-20,true)
  dash(-0.8,-0.8)
  run(-100,true)
  dash(-1,0)
  run(-50,true)
  coroutineEntity:add(jump(1))
  walk(-60,false,1.5)
  coroutineEntity:add(run(-80,false,1.5))
  player.DummyAutoAnimate = false
  player.Sprite:Play("RunStumble")
  walk(-20,false,0.5)
  for i=0,120,1 do
   player.Sprite:Play("Tired")
   wait()
  end
  for i=0,20,1 do
   player.Sprite:Play("TiredStill")
   wait()
  end
  dash(-0.8,0.8)
  for i=0,20,1 do
   player.Sprite:Play("TiredStill")
   wait()
  end
  dash(-0.8,0.8)
  wait(1.2)
  walk(-40,false,0.7)
  coroutineEntity:add(jump(0.25))
  walkTo(-9667,false,0.8)
  wait(0.6)
  wait(0.2)
  player.DummyAutoAnimate = false
  player.Sprite:Play("LookUp")
  wait(0.5)
  say("yakaki_5roomsd_test")
  wait(1)
  player.Sprite:Play("Idle")
  wait(0.3)
  --They've proven to be so scarce.
  dash(0,-1)
  wait(0.5)
end

function onEnd(room, wasSkipped)
  enableMovement()
  
  if wasSkipped then
    completeArea(true)
  end
end