local vector2 = require("#microsoft.xna.framework.vector2")
local exCameraHelper = require("#Celeste.Mod.ExCameraDynamics.Code.Module.ExCameraInterop")

function onBegin()
    
    disableMovement()
    makeUnskippable ()

    setDarkness(0.3)
    setBloomStrength(0.5)

    local level = getLevel()
    coroutine.yield(exCameraHelper.Level_ZoomToFocus(level, vector2(1307, 1874), 1, 0.01))

    player.Facing = getEnum("Celeste.Facings", "Right")
    
    wait(0.8)

    player.ForceCameraUpdate = true
    walkTo (1400, walkBackwards==false, speedMultiplier==1, keepWalkingIntoWalls==false)
    wait(0.5)
    player.DummyAutoAnimate = false
    player.Sprite:Play("lookUp")
    wait(2)
    say("WHE_NaCline_D_06")
    player.DummyAutoAnimate = true
    wait(0.5)
    walkTo (1477, walkBackwards==false, speedMultiplier==1, keepWalkingIntoWalls==false)
    wait(0.5)
    player.DummyAutoAnimate = false
    player.Sprite:Play("lookUp")
    wait(0.5)
    say("WHE_NaCline_D_07")
    player.DummyAutoAnimate = true
    wait(0.5)
    
    walkTo (1304, walkBackwards==false, speedMultiplier==1, keepWalkingIntoWalls==false)

    setFlag("night6", false)

    local darkness = getDarkness ()
    while (true) do
        wait(0.01)
        darkness = darkness + 0.1
        setDarkness (darkness)
        if darkness > 0.9 then
            break
        end
    end

    player.ForceCameraUpdate = false
    
    teleportTo(640, 2095, "night_07")

    enableMovement()
    endCutscene ()

end


