local vector2 = require("#microsoft.xna.framework.vector2")
local exCameraHelper = require("#Celeste.Mod.ExCameraDynamics.Code.Module.ExCameraInterop")

function onBegin()
    
    disableMovement()
    makeUnskippable ()

    setDarkness(0.3)
    setBloomStrength(0.5)

    local level = getLevel()
    coroutine.yield(exCameraHelper.Level_ZoomToFocus(level, vector2(1307, 1252), 1, 0.01))

    player.Facing = getEnum("Celeste.Facings", "Right")
    setFlag("night4",true)

    local darkness = 1
    while (true) do
        wait(0.01)
        darkness = darkness - 0.2
        setDarkness (darkness)
        if darkness < 0.4 then
            break
        end
    end

    wait(0.5)
    
    player.ForceCameraUpdate = true
    walkTo (1392, false, 0.8, false)
    playMusic("event:/WHE/WHE_night")
    wait(0.5)
    player.DummyAutoAnimate = false
    player.Sprite:Play("lookUp")
    wait(2)
    say("WHE_NaCline_D_03")
    wait(1)
    say("WHE_NaCline_D_04")
    wait(1)

    local cameray = 0
    while (true) do
        wait(0.05)
        cameray = cameray - 0.1
        setCameraOffset (0, cameray)

        if cameray < -2 then
            setFlag("playback_night", true)
        end

        if cameray < -5 then
            break
        end

    end

    wait(6)
    
    setFlag("night4", false)

    local darkness = getDarkness ()
    while (true) do
        wait(0.01)
        darkness = darkness + 0.1
        setDarkness (darkness)
        if darkness > 0.9 then
            break
        end
    end
    
    player.DummyAutoAnimate = true

    teleportTo(1384, 896)

    enableMovement()
    endCutscene ()

end


