local vector2 = require("#microsoft.xna.framework.vector2")
local exCameraHelper = require("#Celeste.Mod.ExCameraDynamics.Code.Module.ExCameraInterop")

function onBegin()
    
    disableMovement()
    makeUnskippable ()

    setDarkness(0)
    setBloomStrength(0.1)

    local level = getLevel()
    coroutine.yield(exCameraHelper.Level_ZoomToFocus(level, vector2(656, 1252), 2, 0.01))
    --coroutine.yield(level:ZoomSnap(vector2(160, 90), 2))
    
    wait(0.5)
    walkTo (676, walkBackwards==false, speedMultiplier==0.5, keepWalkingIntoWalls==false)
    wait(0.3)
    player.Facing = getEnum("Celeste.Facings", "Left")
    player.DummyAutoAnimate = false
    wait(0.5)
    player.Sprite:Play("sleep")
    wait(2)
    
    local darkness = getDarkness()
    while (true) do
        wait(0.01)
        darkness = darkness + 0.01
        setDarkness (darkness)
        if darkness > 0.99 then
            break
        end
    end

    wait(1)
    
    player.DummyAutoAnimate = true

    teleportTo(0, 1279, "night_02")
    
    enableMovement()
    endCutscene ()

end


