local vector2 = require("#microsoft.xna.framework.vector2")
local exCameraHelper = require("#Celeste.Mod.ExCameraDynamics.Code.Module.ExCameraInterop")
local cameraFocus = require("#Celeste.Mod.ExCameraDynamics.Code.Entities.CameraFocus")
local cameraZoomHooks = require("#Celeste.Mod.ExCameraDynamics.Code.Hooks.CameraZoomHooks")

function onBegin()

    disableMovement()
    disablePause ()

    setColorGrade("cold")
    setDarkness(0.1)
    setBloomStrength(0.3)
    player.ForceCameraUpdate = false

    wait(1)
    walkTo (7500, walkBackwards==false, speedMultiplier==1, keepWalkingIntoWalls==false)
    wait(1)
    player.DummyAutoAnimate = false
    player.Sprite:Play("lookUp")
    wait(2)
    player.DummyAutoAnimate = true
    wait(1)

    setFlag("LuckyHelper_DisableCameraUpdateOnTeleportFlag",true)
    setFlag("LuckyHelper_DisablePlayerCameraUpdate",true)
    
    local level = getLevel()
    cameraZoomHooks.ForceCameraTo(level, cameraFocus.FromCenter(vector2(7968, 4324), 2))
    teleportTo(7968, 4360, "feel_14")

    enableMovement()
    endCutscene ()
	

end