local songs = require("consts.songs")
local obj = {}

obj.name = "CassetteHelper/CassetteController"
obj.depth = -1000000

obj.fieldInformation = {
    beatIndexOffset = {
        fieldType = "integer",
        minimumValue = 0
    },
    maxBeats = {
        fieldType = "integer",
        minimumValue = 1
    },
    beatsPerTick = {
        fieldType = "integer",
        minimumValue = 1
    },
    ticksPerSwap = {
        fieldType = "integer",
        minimumValue = 1
    },
    leadingBeats = {
        fieldType = "integer",
        minimumValue = 0
    },
    cassetteSong = {
        options = songs,
        editable = true
    }
}

obj.placements = {
    name = "Cassette Block Controller",
    data = {
        beatIndexOffset = 0,
        maxBeats = 256,
        beatsPerTick = 4,
        ticksPerSwap = 2,
        leadingBeats = 0,
        cassetteSong = ""
    }
}

obj.texture = "objects/CassetteHelper/cassetteController/icon"

return obj