local languageRegistry = require("language_registry")
local drawing = require("utils.drawing")
local drawableRect = require("structs.drawable_rectangle")
local colors = require("consts.colors")

local language = languageRegistry.getLanguage()

local exports = {
  name = "Bitsbolts/ResizeTriggers",
  placements = {
    {
      name = "this",
      data = {
        mode = "this"
      }
    },
    {
      name = "area",
      data = {
        mode = "area",
        nodes = {{}, {}}
      }
    },
    {
      name = "level",
      data = {
        mode = "level"
      }
    },
    {
      name = "map",
      data = {
        mode = "map"
      }
    },
    {
      name = "infinite",
      data = {
        mode = "infinite"
      }
    },
  },
  nodeLimits = function (room, trigger)
    if trigger.mode ~= nil and trigger.mode == "area"
    then return 2, 2 else return 0, 0 end
  end,
  -- fixme: nodeVisibility is buggy and doesn't work as expected wtf?
  -- nodeVisibility = function (trigger)
  --   if trigger.mode ~= nil and trigger.mode == "area"
  --   then return "always" else return "never" end
  -- end,
  nodeLineRenderType = false,
  fieldInformation = function (trigger)
    return {
      mode = {
        options = {
          { tostring(language.triggers["Bitsbolts/ResizeTriggers"].covermode.this), "this" },
          { tostring(language.triggers["Bitsbolts/ResizeTriggers"].covermode.area), "area" },
          { tostring(language.triggers["Bitsbolts/ResizeTriggers"].covermode.level), "level" },
          { tostring(language.triggers["Bitsbolts/ResizeTriggers"].covermode.map), "map" },
          { tostring(language.triggers["Bitsbolts/ResizeTriggers"].covermode.infinite), "infinite" },
        },
        editable = false
      }
    }
  end,
}

local borderColor = {1.0, 1.0, 1.0, 1.0}

-- function exports.sprite(room, trigger, viewport)
--   if trigger.mode == "area" then
--     if trigger.nodes ~= nil and #trigger.nodes == 2 then
--       return {
--         drawableRect.fromRectangle(
--           "line",
--           trigger.nodes[1].x,
--           trigger.nodes[1].y,
--           trigger.nodes[2].x - trigger.nodes[1].x,
--           trigger.nodes[2].y - trigger.nodes[1].y,
--           borderColor
--         )
--       }
--     end
--   end
-- end

return exports
