-- vectors

local function round(num)
  if num >= 0 then
    return math.floor(num + 0.5)
  else
    return math.ceil(num - 0.5)
  end
end


local vec2_mt = {
  __name = "vec2"
}
vec2_mt.__index = vec2_mt

local function vec2(x, y)
  return setmetatable({x = x, y = y}, vec2_mt)
end

function vec2_mt.__add(vec1, _vec2)
  return vec2(vec1.x + _vec2.x, vec1.y + _vec2.y)
end

function vec2_mt.__sub(vec1, _vec2)
  return vec2(vec1.x - _vec2.x, vec1.y - _vec2.y)
end

function vec2_mt.__mul(vec1, _vec2)
  if type(_vec2) ~= "table" then
    return vec2(vec1.x * _vec2, vec1.y * _vec2)
  else
    return vec2(vec1.x * _vec2.x, vec1.y * _vec2.y)
  end
end

function vec2_mt.__div(vec1, _vec2)
  if type(_vec2) ~= "table" then
    return vec2(vec1.x / _vec2, vec1.y / _vec2)
  else
    return vec2(vec1.x / _vec2.x, vec1.y / _vec2.y)
  end
end

-- function vec2_mt.__idiv(vec1, _vec2)
--   if type(_vec2) ~= "table" then
--     return vec2(vec1.x * _vec2, vec1.y * _vec2)
--   else
--     return vec2(vec1.x.__idiv(_vec2.x), vec1.y // _vec2.y)
--   end
-- end

function vec2_mt.__unm(vec)
  return vec2(-vec.x, -vec.y)
end

function vec2_mt.__eq(vec1, _vec2)
  return vec1.x == _vec2.x and vec1.y == _vec2.y
end

function vec2_mt.__len(vec)
  return math.sqrt(vec.x*vec.x + vec.y*vec.y)
end

function vec2_mt.__tostring(vec)
  return "(" .. vec.x .. ", " .. vec.y .. ")"
end


function vec2_mt.floor(vec)
  return vec2(math.floor(vec.x), math.floor(vec.y))
end

function vec2_mt.round(vec)
  return vec2(round(vec.x), round(vec.y))
end

function vec2_mt.idiv(vec1, _vec2)
  if type(_vec2) ~= "table" then
    return vec2(math.floor(vec1.x / _vec2), math.floor(vec1.y / _vec2))
  else
    return vec2(math.floor(vec1.x / _vec2.x), math.floor(vec1.y / _vec2.y))
  end
end

function vec2_mt.normalize(vec)
  return vec / (#vec)
end


return vec2
