local vec2 = require("mods").requireFromPlugin("lib.bitsbolts.vec2")

-- rectangles

local function round(num)
  if num >= 0 then
    return math.floor(num + 0.5)
  else
    return math.ceil(num - 0.5)
  end
end


local rect2_mt = {
  __name = "rect2"
}
rect2_mt.__index = rect2_mt

local function rect2(p1, p2)
  local q1 = vec2(math.min(p1.x, p2.x), math.min(p1.y, p2.y))
  local q2 = vec2(math.max(p1.x, p2.x), math.max(p1.y, p2.y))
  return setmetatable({p1 = q1, p2 = q2}, rect2_mt)
end

function rect2_mt.__eq(rect1, rect2)
  return rect1.p1 == rect2.p1 and rect1.p2 == rect2.p2
end

function rect2_mt.__tostring(rect)
  return "(" .. tostring(rect.p1) .. ", " .. tostring(rect.p2) .. ")"
end

function rect2_mt.width(rect)
  return rect.p2.x - rect.p1.x
end

function rect2_mt.height(rect)
  return rect.p2.y - rect.p1.y
end

function rect2_mt.floor(rect)
  return rect2(math.floor(rect.p1), math.floor(rect.p2))
end

function rect2_mt.round(rect)
  return rect2(round(rect.x), round(rect.y))
end

return rect2
