local rectangle = require("structs.rectangle")
local drawableRectangle = require("structs.drawable_rectangle")


local exports = {
  name = "Bitsbolts/WorldPortal",

  placements = {
    {
      name = "entity",
      data = { height = 72, width = 128, flags = "", nodes = {{}} }
    },
  },

  nodeLimits = {1, 1},
  nodeLineRenderType = "line",

  sprite = function(room, entity)
    local color = {255/255, 255/255, 255/255, 64/255}
    return drawableRectangle.fromRectangle(
      "fill", entity.x, entity.y, entity.width, entity.height, color
    )
  end,

  rectangle = function(room, entity)
    return rectangle.create(
      entity.x, entity.y, entity.width, entity.height
    )
  end,
}

return exports
