local drawableNinePatch = require("structs.drawable_nine_patch")
local drawableSprite = require("structs.drawable_sprite")

local exports = {
  name = "Bitsbolts/GrablessBerryBlock",
  texture = "bitsbolts/grabless_berry/block",
  depth = -10000,
  minimumSize = {16, 16},
  placements = {
    name = "entity",
    data = {
      width = 16,
      height = 16,
      floaty = true,
    }
  }
}

function exports.sprite(room, entity)
  local x, y = entity.x or 0, entity.y or 0
  local width, height = entity.width or 24, entity.height or 24

  local sprites = drawableNinePatch.fromTexture(
    "bitsbolts/grabless_berry/block",
    {
      mode = "fill",
      borderMode = "repeat",
      fillMode = "repeat"
    },
    x,
    y,
    width,
    height
  ):getDrawableSprite()

  local berry = drawableSprite.fromTexture("bitsbolts/grabless_berry/idle00", entity)
  berry:addPosition(math.floor(width / 2), math.floor(height / 2))

  table.insert(sprites, berry)
  return sprites
end

return exports
