-- this is the public variant of this entity, without the placement

local drawableFunction = require("structs.drawable_function")
local rectangle = require("structs.rectangle")
local drawing = require("utils.drawing")

local function format_plain(text)
  return text:gsub("%{break%}", "\n"):gsub("%{n%}", "\n"):gsub("%{[^%}]*%}", "")
end

local exports = {
  name = "Bitsbolts/DebugCoreMessage",
  depth = -1000000,

  sprite = function(room, entity)
    local font = love.graphics.getFont()
    return drawableFunction.fromFunction(function()
      drawing.callKeepOriginalColor(function()
        local text = entity.dialog
        if text == nil or text == "" then text = "Text" end
        love.graphics.setColor({255 / 255, 255 / 255, 255 / 255})
        drawing.printCenteredText(
          format_plain(text), entity.x, entity.y, entity.width, entity.height, font, 1
        )
      end)
    end)
  end,

  rectangle = function(room, entity)
    return rectangle.create(entity.x, entity.y, entity.width, entity.height)
  end,

  selection = function(room, entity)
    return rectangle.create(entity.x, entity.y, entity.width, entity.height)
  end,
}

return exports
