# bits & bolts documentation
> he would never write documentation wtf

Fucking read tooltips people! Every field has a tooltip with some helpful information on what it does or what format it expects. Also see [Formats](#formats) for important documentation on how flags work in this mod!

- [bits \& bolts documentation](#bits--bolts-documentation)
  - [Demonstration Map](#demonstration-map)
  - [Formats](#formats)
    - [Flagstrings](#flagstrings)
    - [Level Globs](#level-globs)
    - [Fancy Text](#fancy-text)
  - [Entities](#entities)
    - [Enable Triggers in Reflection Fall State Controller](#enable-triggers-in-reflection-fall-state-controller)
    - [Global Room Loader Controller](#global-room-loader-controller)
    - [Grabless Berry](#grabless-berry)
    - [Mostly Temporary Key](#mostly-temporary-key)
    - [Save Data Flag Sync Controller](#save-data-flag-sync-controller)
    - [Sturdy Dash Block](#sturdy-dash-block)
    - [World Camera](#world-camera)
    - [World Portal](#world-portal)
  - [Triggers](#triggers)
    - [Adjust Speed](#adjust-speed)
    - [Block Ledge Hop](#block-ledge-hop)
    - [Block Screen Transitions](#block-screen-transitions)
    - [Change Level Bounds](#change-level-bounds)
    - [Change Respawn Cross Room](#change-respawn-cross-room)
    - [Flags](#flags)
    - [Flag Lookout Blocker](#flag-lookout-blocker)
    - [Flag Zone](#flag-zone)
    - [Grabless Berry Collect](#grabless-berry-collect)
    - [Laggy Trigger](#laggy-trigger)
    - [No Retry](#no-retry)
    - [Passage Trigger](#passage-trigger)
    - [Redirect Motion](#redirect-motion)
    - [Resize Triggers](#resize-triggers)
    - [Skip Badeline Boost](#skip-badeline-boost)
    - [Seamless Teleport](#seamless-teleport)
    - [Strawberry Allowfield](#strawberry-allowfield)
    - [Unlock Camera](#unlock-camera)
    - [Unlock Level Boundaries](#unlock-level-boundaries)
  - [Commands](#commands)


## Demonstration Map
There's a demo map that showcases most of the entities and triggers from this mod, and some common layouts for more complex entities. The map has labels and comments in-game and in Lönn.

Load the map by running `load bitsbolts/demo` in the console (open with the tilde key), or if you have Celeste running, [click here to load the map](http://localhost:32270/tp?area=bitsbolts/demo&side=A&level=a1).

## Formats

### Flagstrings
All flag options for this mod supports *flagstrings*, a way to invert and encode multiple flags.
Use `!flag` to check/set the inverse of a flag, and separate multiple flags with commas: `flag1,!flag2,flag3`.

If flags are being checked, all provided flags need to match and be the correct value.
If flags are being set, all flags are set to the given value.
If flags are being unset, all flags are set to the inverted value.

### Level Globs
Level globs for this mod work similarly to the level globs used in stylegrounds.
Seperate multiple globs with commas and exclude rooms with exclamation marks: `roomname1,!roomname2,room3-*`. The wildcard `*` may match any number of characters.

### Fancy Text
Works anywhere fancy text is used in game. This includes the usual things like dialog textboxes, but sometimes some estoric things like menu entries:
- `{^ 1.5}` sets the text size to 150% of normal size. `1.0` is normal size.
- `{/^}` resets the text size to normal


## Entities

### Enable Triggers in Reflection Fall State Controller
This fixes an ugly hack in vanilla where the reflection fall state (18) inhibits the ability for the player to activate triggers.
With this controller in a room, triggers can be activated regardless.

### Global Room Loader Controller
This controller configures how entities and triggers from global rooms are loaded.

[View the "visual documentation"](https://files.catbox.moe/z3mvio.mp4)

In general, this mod recognizes any room whose name *starts with* `_bb_global` as a *global room*. By default, entities or triggers that are placed in a global room will be automatically loaded on every room in the whole map, even if there's not this controller in it. Keep in mind that the position of entities and triggers is not deterministic due to awful loading quirks. So, if you are placing down positionally-activated triggers, consider using a [resize trigger trigger](#resize-triggers) to resize the triggers to the screen or map size.

To configure how a specific global room is loaded, place a global room loader controller in the global room. Then, the global room will only be loaded if the controller's flags/room list matches (if fields are present).

Note: after creating a room starting with `_bb_global`, since Lönn will consider the global room as the first room, you may need to change your map's default starting room in map metadata to your map's actual starting room.

### Grabless Berry
A persistent challenge berry which disables grabbing, walljumping, and/or climbjumping (configurable). The berry survives deaths and reloads. Use either the golden berry collect trigger, or the special [Grabless Berry Collect Trigger](#grabless-berry-collect) to trigger collection. Similar to goldens, will collect when the player collects a crystal heart at the end of a B/C-side, or when "End Level on Heart" is checked.

### Mostly Temporary Key
A key which largely acts like the Temporary Key from Frost Helper, but doesn't respawn after use, is intended to be used on normal key doors, and survives screen transitions. It disappears from the player and respawns at the key's spawnpoint when the player dies. If it was used to unlock a door, it will never respawn again for the current session.

### Save Data Flag Sync Controller
A controller which synchronizes flags and loads/saves them to the savefile. This adds persistence to flags allowing them to be saved and loaded even between map restarts. Changes to flags are immediate. It is safe to have multiple identical flag controllers spread across different rooms.

Flags are stored as vanilla savedata flags prefixed with the given prefix like so: `prefix:flag`. If prefix is empty, then the map SID is used as the prefix: `yourmod/yourmap:flag`.
If raw is checked, flags are stored into savedata as is, with no prefixing whatsoever.

Unless you know exactly what you are doing, **do not use raw mode**: using raw mode may cause flag conflicts between maps from other mods! If you need to share savedata flags between your own maps, instead, set the same unique prefix on controllers between your maps (e.g. a prefix of `yourmod`).

### Sturdy Dash Block
A dash block that is sturdy enough to stop kevins/melvins and red bubbles that collide with the block. Collisions still break the block. Otherwise acts identically to a dash block.

### World Camera
A virtual camera that renders the noded area in the bounds of this entity. Looping stylegrounds will be seamlessly fit. Can be flag toggled.

There are several rendering bugs with some entities (spinners, seeker barriers, water, lightning), and some styleground effects.

### World Portal
A seamless one-directional portal entity that teleports actors (players, theo, jelly, etc.) to the other side of the portal. Looping stylegrounds will be seamlessly fit. Can be flag toggled.

There are several rendering bugs with some entities (spinners, seeker barriers, water, lightning), and some styleground effects.


## Triggers
### Adjust Speed
Imperceptibly adjusts the player speed to an constant value if it's within the given range to help make setups (especially those involving ultras) more consistent without the player noticing. Tip: to determine speed values to use, it may help to use Extended Variant's Speedometer.

### Block Ledge Hop
Prevents automatic ledge hopping when climbing up on a wall around a corner. This functionality is normally provided by hazards (like spikes) to prevent the player from automatically climbing right into spikes, but is sometimes useful to manually place down.

### Block Screen Transitions
Blocks screen transitions when the player is inside the trigger. Can be flag toggled.

Placing upwards or downwards blocking triggers requires 2 tiles of extra padding beyond the room border to account for the lower deathplane and ceiling headroom. Using a [resize trigger trigger](#resize-triggers) on this to resize it to room size will correctly account for this extra padding.

### Change Level Bounds
Changes the level boundaries to the noded region while the trigger is activated. I sure hope you know what you're doing.

### Change Respawn Cross Room
A change respawn trigger that is able to work across rooms. Can be flag toggled. Can exactly set spawn position instead of using the closest spawn in the room.

### Flags
A flag trigger that supports setting multiple flags at a time using flagstrings. Also supports setting flags on room load (trigger added) or room unload (trigger removal).

### Flag Lookout Blocker
A flag toggled lookout blocker.

### Flag Zone
A flag trigger which has the end effect of setting flags whenever the player is in the trigger. If the player leaves the trigger the flags are unset. Optionally flags can also be unset on level load, making the state of the flags solely controlled by if the player is in the trigger.

### Grabless Berry Collect
Immediately collects all held grabless berries. Can be flag toggled.

### Laggy Trigger
Induces artificial lag. Period (time between lag spikes) and duration (length of lag spikes) are sampled from a Gaussian distribution.

### No Retry
Disables the retry option from the pause menu. Can be flag toggled.

### Passage Trigger
Opens passages to the list of rooms so long as this trigger is activated. Place on both sides of a room boundary to keep the passage open on both ends. Works with level music, camera offsets, lighting, etc.

Since this modifies the level bounds, this will cause camera/killbox jank and may cause jank with select entities (especially controllers). Try using camera borders/triggers and killboxes.

### Redirect Motion
Redirects player motion to a specific direction on entering the trigger. Can be flag toggled. Works well with dream blocks, teleport triggers, boosters, etc.

### Resize Triggers
[View trigger "documentation"](https://files.catbox.moe/svd8ua.mp4)

Resize triggers have many modes that changes how triggers inside should be resized:

- *Cover this trigger:* triggers will be resized to fit the same bounds as this resize trigger
- *Cover specified noded area:* triggers will be resized to fit the rectangular area defined by two nodes (corner to corner)
- *Cover this room:* triggers are resized to fit the current room/level's bounds, plus some extra vertical space to account for the deathplane and top headroom
- *Cover entire map:* triggers are resized to cover the rectangle bounds covered by the union of the space covered by every room/level in the map
- *Cover fucking everything:* triggers are resized to cover everything in the game space, including out-of-bounds

### Skip Badeline Boost
Advances to the specified node in the selected badeline boost entity. If there are multiple boost entities in the level, create a new node and place it close to the target entity. Does not advance to previous nodes unless backwards is selected. Works well for mid-room player spawnpoints if instant is selected. Works with some modded badeline boost entities.

### Seamless Teleport
Teleports the player from the trigger bounds to the node, seamlessly, fixing up hair trails, followers, and stylegrounds/effects. Uses the same seamless teleportation logic as [world portals](#world-portal), but obviously without all the visual magic to make it happen; use this in conjuction with [world cameras](#world-camera) if you want to achieve that.

### Strawberry Allowfield
The opposite of the Strawberry Blockfield Entity. Considers whatever ground the player is standing on as "safe ground" and allows collection of berries, irrespective of the type of ground. Allows berry collection when standing on the following entities:
- Cassette blocks
- Crumble blocks
- Glass blocks
- Ice/boost/core blocks
- Intro crushers
- Key doors
- Move blocks
- Swap blocks
- Switch gates
- Zipper blocks
- All variants of trigger spikes
- Probably some more solids that I forgot about
- Probably all modded entities that mark unsafe ground too who knows

### Unlock Camera
Frees the *camera* from silly constraints like the bounds of the level or killboxes. Can be flag toggled.

### Unlock Level Boundaries
Frees the *player* from silly constraints like the bounds of the level. Can be flag toggled.


## Commands
- `bb_flag` Lists all session flags. This is the *normal* type of flag that you'll use in maps.
- `bb_flag [flag]` Gets the session flag named `flag`.
- `bb_flag [flag] [0/1/true/false]` Sets or unsets the flag `flag`.
- `bb_levelflag` Lists all level flags.
- `bb_levelflag [flag]` Gets the level flag named `flag`.
- `bb_levelflag [flag] [0/1/true/false]` Sets or unsets the level flag `flag`.
- `bb_saveflag` Lists all save data flags.
- `bb_saveflag [flag]` Gets the save data flag named `flag`.
- `bb_saveflag [flag] [0/1/true/false]` Sets or unsets the save data flag `flag`. Careful, this may affect other maps on the same savefile!
- `bb_dnlflag` Lists all do not load flags.
- `bb_dnlflag [level:id]` Gets the do not load flag named `level:id`.
- `bb_dnlflag [level:id] [0/1/true/false]` Sets or unsets the do not load flag `level:id`.
- `bb_entityflag` Lists all session entity flags.
- `bb_entityflag [level:id]` Gets the session entity flag named `level:id`.
- `bb_entityflag [level:id] [0/false]` Removes the session entity flag `level:id`.
- `bb_give_jelly` Spawns in an immortal jellyfish.
- `bb_enforce_bounds [0/1/true/false]` Toggles enforcing level bounds.
- `bb_passage_load_all` Loads every room in the map as a passage. Stupendously janky and laggy!
- `bb_ent [entityname]` Spawns in an entity from any mod by it's entity name, as it shows in the Lönn entity options titlebar (e.g. `bb_ent glider` for vanilla jellys, or `bb_ent DreamJellyfish` for CommunalHelper dream jellys). Careful, some complex entities may crash the game :(
- `bb_giveglb` Gives the player a grabless berry
- `bb_giveglbjump` Gives the player a grabless berry with no walljumping
