---@diagnostic disable-next-line: undefined-field
local luanet = _G.luanet
---@diagnostic disable-next-line: undefined-field
local player = _G.player
---@diagnostic disable-next-line: undefined-field
local cutsceneEntity = _G.cutsceneEntity
---@diagnostic disable-next-line: undefined-field
local helpers = _G.helpers

local expect = require("Assets/bitsbolts/Lua/expect");
local tablex = require("Assets/bitsbolts/Lua/tablex");

local CreditsScroller = require("#Bitsbolts.Entities.CreditsScroller");
local FancyTextComponent = require("#Bitsbolts.Components.FancyTextComponent");

local Calc = require("#Monocle.Calc");
local Engine = require("#Monocle.Engine");
local Vector2 = require("#Microsoft.Xna.Framework.Vector2")

local Dialog = require("#Celeste.Dialog");
local FancyText = require("#Celeste.FancyText");


function helpers.vector2(x, y)
  if type(x) == "table" and not y then return Vector2(x[1], x[2])
  elseif type(x) == "userdata" and not y then return x
  else return Vector2(x, y) end
end


local function dialog_rawnl(key)
  expect(1, key, "string")

  if not Dialog.Has(key, nil) then return key end
  return tostring(Dialog.Get(key, nil):gsub("{break}", "{n}"))
end


local exports = {}

function exports.get_screen_size()
  return helpers.vector2(Engine.Width, Engine.Height)
end

function exports.create(x, y, width, height)
  return exports.create_vector(
    helpers.vector2(x, y),
    helpers.vector2(width, height)
  )
end

function exports.create_center(x, y, width, height)
  return exports.create_vector(
    helpers.vector2(x - width/2, y - width/2),
    helpers.vector2(width, height)
  )
end

function exports.create_vector(position, size)
  expect(1, position, "userdata", "nil")
  expect(2, size, "userdata", "nil")

  local credits = CreditsScroller(position, size)
  helpers.getLevel():Add(credits)
  return credits
end

function exports.add_text(credits, dialog, options)
  expect(1, credits, "userdata")
  expect(2, dialog, "string")
  options = expect(2, options, "table", "nil") or {}
  options = tablex.apply({
    position = helpers.vector2(credits.Width / 2, 0),
    justify = helpers.vector2(0.5, 0),
    justify_per_line = true,
    width = credits.Width,
    lines = 1000,
    color = nil,
  }, options)
  expect.field(options, "position", "userdata")
  expect.field(options, "justify", "userdata")
  expect.field(options, "justify_per_line", "boolean")
  expect.field(options, "width", "number")
  expect.field(options, "lines", "number")
  expect.field(options, "color", "string", "userdata", "nil")

  if type(options.color) == "string" then
    options.color = Calc.HexToColor(options.color)
  end

  local text = FancyTextComponent(
    FancyText.Parse(
      dialog_rawnl(dialog),
      options.width,
      options.lines,
      1.0,
      options.color,
      nil
    ),
    options.position,
    options.justify,
    options.justify_per_line
  )
  credits:Add(text)
  return text
end

return exports
