﻿using System;
using System.Collections;
using System.Reflection;
using Microsoft.Xna.Framework;
using Monocle;
using MonoMod.Cil;
using MonoMod.RuntimeDetour;
using MonoMod.Utils;
namespace Celeste.Mod.borealisHelper;

public class borealisHelperModule : EverestModule {
    public static borealisHelperModule Instance { get; private set; }

    private static bool specialEnabled => borealisHelperModuleSettings.SuperMode;
    private static ILHook dashCoroutineHook;
    public static bool startedSuperDash = false;
    public static Session session = null;

    public override Type SettingsType => typeof(borealisHelperModuleSettings);
    public static borealisHelperModuleSettings Settings => (borealisHelperModuleSettings) Instance._Settings;

    public override Type SessionType => typeof(borealisHelperModuleSession);
    public static borealisHelperModuleSession Session => (borealisHelperModuleSession) Instance._Session;

    public override Type SaveDataType => typeof(borealisHelperModuleSaveData);
    public static borealisHelperModuleSaveData SaveData => (borealisHelperModuleSaveData) Instance._SaveData;

    public borealisHelperModule() {
        Instance = this;

#if DEBUG
        // debug builds use verbose logging
        Logger.SetLogLevel(nameof(borealisHelperModule), LogLevel.Verbose);
#else
        // release builds use info logging to reduce spam in log files
        Logger.SetLogLevel(nameof(borealisHelperModule), LogLevel.Info);
#endif
    }

    public override void Load() {
        // TODO: apply any hooks that should always be active
        On.Celeste.Player.Update += modUpdate;
        On.Celeste.Player.DashEnd += customDashEnd;
        On.Celeste.Level.Begin += modLevelBegin;

        IL.Celeste.Player.DashBegin += ModSuperDashChecks;
        IL.Celeste.Player.DashUpdate += ModSuperDashChecks;
        dashCoroutineHook = new ILHook(typeof(Player).GetMethod("DashCoroutine", BindingFlags.NonPublic | BindingFlags.Instance).GetStateMachineTarget(), ModSuperDashChecks);
    }

    public override void Unload() {
        // TODO: unapply any hooks applied in Load()
        On.Celeste.Player.Update -= modUpdate;
        On.Celeste.Player.DashEnd -= customDashEnd;
        On.Celeste.Level.Begin -= modLevelBegin;

        IL.Celeste.Player.DashBegin -= ModSuperDashChecks;
        IL.Celeste.Player.DashUpdate -= ModSuperDashChecks;
        dashCoroutineHook.Dispose();
        dashCoroutineHook = null;
    }


    private static void ModSuperDashChecks(ILContext ctx) {
            ILCursor cursor = new(ctx);
            // We want every effect that checks for SuperDash to also trigger for our refill
            while (cursor.TryGotoNext(MoveType.After, instr => instr.MatchLdfld(typeof(Assists), "SuperDashing"))) {
                cursor.EmitDelegate<Func<bool, bool>>((superDashVariantActive) => {
                    return superDashVariantActive || borealisHelperModule.startedSuperDash;
            });
        }
    }

    private void modLevelBegin(On.Celeste.Level.orig_Begin orig, Level level)
        {
            orig(level);
            session = level.Session;
        }


    private static void customDashEnd(On.Celeste.Player.orig_DashEnd orig, Player player)
    {
        startedSuperDash = false;
        orig(player);
    }

    private static void modUpdate(On.Celeste.Player.orig_Update orig, Player player)
    {
        orig(player);
        if(Settings.SuperBind.Pressed && player.Dashes > 0 && (specialEnabled || session.GetFlag("SuperMode")))
        {
            startedSuperDash = true;
            player.StateMachine.State = 2;
            player.StartDash();

        }
    }
}


