using Celeste.Mod.Entities;
using Celeste.Mod.borealisHelper;
using Microsoft.Xna.Framework;

namespace Celeste.Mod.borealisHelper;

[CustomEntity("borealisHelper/SuperModeTrigger")]
public class SuperModeTrigger : Trigger {

    bool enable;
    bool revertOnExit;

    public SuperModeTrigger(EntityData data, Vector2 offset) : base(data, offset) {
        // TODO: read properties from data
        enable = data.Bool("enable", true);
        revertOnExit = data.Bool("revertOnExit", false);
    }

    public override void OnEnter(Player player)
    {
        SceneAs<Level>().Session.SetFlag("SuperMode", enable);
    }
    public override void OnLeave(Player player)
    {
        if(revertOnExit)
        {
            SceneAs<Level>().Session.SetFlag("SuperMode", false);
        }
    }
}