using Celeste.Mod.Entities;
using Microsoft.Xna.Framework;
using Monocle;

namespace Celeste.Mod.exampleMod.Entities;

[CustomEntity("borealisHelper/SampleEntity")]
public class SampleEntity : Entity {
    public SampleEntity(EntityData data, Vector2 offset)
        : base(data.Position + offset) {
        // TODO: read properties from data
        Add(GFX.SpriteBank.Create("sampleEntity"));
        Collider = new Hitbox(16, 16, -8, -8);
        Add(new PlayerCollider(OnPlayer));
    }
    private void OnPlayer(Player player)
    {
        player.Speed = new Vector2(0,20);
    }
    public override void Update()
    {
        // Remember to call base.Update() to update your entity's components!
        // (read more about components below)
        base.Update();

        // Spawn confetti every second at the entity position
        if (Scene.OnInterval(1f))
            Scene.Add(new SummitCheckpoint.ConfettiRenderer(Position));
    }
}