local PlayerCannon = {}

PlayerCannon.name = "probananahelper/PlayerCannon"
PlayerCannon.depth = -8500
PlayerCannon.placements = {
    {
        name = "PlayerCannonBlue",
        data = {
            angle = 0,
            strength = 500,
            type = "Blue"
        }
    },
    {
        name = "PlayerCannonGreen",
        data = {
            angle = 0,
            strength = 500,
            rotationSpeed = 4,
            moveX = 0;
            moveY = 0;
            moveTime = 1;
            alwaysMove = false;
            startClockwise = true;
            turns = 0;
            type = "Green"
        }
    },
    {
        name = "PlayerCannonRed",
        data = {
            angle = 0,
            strength = 500,
            rotationSpeed = 4,
            type = "Red"
        }
    },
    {
        name = "PlayerCannonPurple",
        data = {
            angle = 0,
            strength = 500,
            rotationSpeed = 4,
            type = "Purple"
        }
    },
    {
        name = "PlayerCannonCheckpoint",
        data = {
            angle = 0,
            strength = 500,
            type = "Checkpoint"
        }
    },
    {
        name = "PlayerCannonTimeWarp",
        data = {
            angle = 0,
            strength = 500,
            rotationSpeed = 4,
            moveX = 0;
            moveY = 0;
            moveTime = 1;
            timeWarpSec = 5;
            alwaysMove = false;
            startClockwise = true;
            turns = 0;
            type = "TimeWarp"
        }
    }
}

PlayerCannon.fieldInformation = {
	type = {
		options = {
			"Blue",
			"Green",
			"Red",
			"Purple",
			"Checkpoint",
			"TimeWarp"
		},
		editable = false
	}
}

function PlayerCannon.rotation(room, entity)
    return math.rad(entity.angle)
end
function PlayerCannon.texture(room, entity)
	local path = "objects/probananahelper/cannon/"
	if entity.type == "Green" then
		return path .. "fullB00"
	elseif entity.type == "Red" then
		return path .. "fullC00"
	elseif entity.type == "Purple" then
		return path .. "fullD00"
	elseif entity.type == "Checkpoint" then
		return path .. "fullE00"
	elseif entity.type == "TimeWarp" then
		return path .. "fullF00"
	else
		return path .. "fullA00"
	end
end

return PlayerCannon