#define DECLARE_TEXTURE(Name, index) \
    texture Name: register(t##index); \
    sampler Name##Sampler: register(s##index)

#define SAMPLE_TEXTURE(Name, texCoord) tex2D(Name##Sampler, texCoord)

uniform float Time; // level.TimeActive
uniform float2 CamPos; // level.Camera.Position
uniform float2 Dimensions; // new Vector2(320, 180)

uniform float4x4 TransformMatrix;
uniform float4x4 ViewMatrix;

DECLARE_TEXTURE(text, 0);

float4 SpritePixelShader(float2 uv : TEXCOORD0) : COLOR0
{
    float2 worldPos = (uv * Dimensions) + CamPos;
    float2 vu = float2(trunc(worldPos.x/2),trunc(worldPos.y/2));
    float2 vu2 = float2(trunc(worldPos.x/10),trunc(worldPos.y/10));

    float noiseY = (frac(sin(dot(vu/10, float2(100 * trunc(Time/9+500),1000))) * 200 + Time/7));
    float noiseX = (frac(sin(dot(vu/10, float2(200 * trunc(Time/7+500),1000))) * 300 + Time/9));
    float noiseZ = (frac(sin(dot(vu/10, float2(300 * trunc(Time/10+500),1000))) * 100 + Time/11));
    float4 color2 = float4(noiseX/2+0.5,noiseY/2+0.5,noiseZ/2+0.5,1);

    float4 color = SAMPLE_TEXTURE(text, uv);
    color = saturate(float4(color.r,2*color.g-color2.r-color2.g,2*color.b-color2.r-color2.b,3));
    return color;
}

void SpriteVertexShader(inout float4 color    : COLOR0,
                        inout float2 texCoord : TEXCOORD0,
                        inout float4 position : SV_Position)
{
    position = mul(position, ViewMatrix);
    position = mul(position, TransformMatrix);
}

technique Shader
{
    pass pass0
    {
        VertexShader = compile vs_3_0 SpriteVertexShader();
        PixelShader = compile ps_3_0 SpritePixelShader();
    }
}