#define DECLARE_TEXTURE(Name, index) \
    texture Name: register(t##index); \
    sampler Name##Sampler: register(s##index)

#define SAMPLE_TEXTURE(Name, texCoord) tex2D(Name##Sampler, texCoord)

uniform float Time; // level.TimeActive
uniform float2 CamPos; // level.Camera.Position
uniform float2 Dimensions; // new Vector2(320, 180)

uniform float4x4 TransformMatrix;
uniform float4x4 ViewMatrix;

DECLARE_TEXTURE(text, 0);

float4 SpritePixelShader(float2 uv : TEXCOORD0) : COLOR0
{
    float2 worldPos = (uv * Dimensions) + CamPos;
    float2 vu = float2(trunc(worldPos.x/50),trunc(worldPos.y/50));

    float noiseY = (frac(sin(dot(vu, float2(3.598 * trunc((Time+30)/3),52.773))) * 1388.5453));
    float noiseX = (frac(sin(dot(vu, float2(12.9898 * trunc((Time+30)/3),78.233))) * 43758.5453));
    float noiseZ = (frac(sin(dot(vu, float2(9.498 * trunc((Time+30)/3),88.773))) * 2369.5453));
    float4 color2 = float4(noiseX,noiseY,noiseZ,1.0);

    float4 color = SAMPLE_TEXTURE(text, uv);
    return (color+color2)/2;
    return color;
}

void SpriteVertexShader(inout float4 color    : COLOR0,
                        inout float2 texCoord : TEXCOORD0,
                        inout float4 position : SV_Position)
{
    position = mul(position, ViewMatrix);
    position = mul(position, TransformMatrix);
}

technique Shader
{
    pass pass0
    {
        VertexShader = compile vs_3_0 SpriteVertexShader();
        PixelShader = compile ps_3_0 SpritePixelShader();
    }
}