#define DECLARE_TEXTURE(Name, index) \
    texture Name: register(t##index); \
    sampler Name##Sampler: register(s##index)

#define SAMPLE_TEXTURE(Name, texCoord) tex2D(Name##Sampler, texCoord)

uniform float Time; // level.TimeActive
uniform float2 CamPos; // level.Camera.Position
uniform float2 Dimensions; // new Vector2(320, 180)

uniform float4x4 TransformMatrix;
uniform float4x4 ViewMatrix;

DECLARE_TEXTURE(text, 0);

float4 SpritePixelShader(float2 uv : TEXCOORD0) : COLOR0
{
    float2 worldPos = trunc(uv * Dimensions/2 + CamPos/2)*2;
    float4 color2 = SAMPLE_TEXTURE(text, (worldPos - CamPos)/Dimensions);
    float4 color = SAMPLE_TEXTURE(text, uv);

    /*float2 uv2 = trunc(worldPos/4 - CamPos/4)/Dimensions*4;
    float2 uv3 = trunc(worldPos/4 - CamPos/4 + float2(1.0,1.0))/Dimensions*4;
    float2 uv4 = trunc(worldPos/4 - CamPos/4 + float2(1.0,0.0))/Dimensions*4;
    float2 uv5 = trunc(worldPos/4 - CamPos/4 + float2(0.0,1.0))/Dimensions*4;
    
    float4 color2 = (SAMPLE_TEXTURE(text, uv2)+SAMPLE_TEXTURE(text, uv3)+SAMPLE_TEXTURE(text, uv4)+SAMPLE_TEXTURE(text, uv5))/4;
    
    float2 vu = float2(trunc(worldPos.x/2)*2,trunc(worldPos.y/2)*2);*/



    return (color+color2)/2.0;
}

void SpriteVertexShader(inout float4 color    : COLOR0,
                        inout float2 texCoord : TEXCOORD0,
                        inout float4 position : SV_Position)
{
    position = mul(position, ViewMatrix);
    position = mul(position, TransformMatrix);
}

technique Shader
{
    pass pass0
    {
        VertexShader = compile vs_3_0 SpriteVertexShader();
        PixelShader = compile ps_3_0 SpritePixelShader();
    }
}