local mods = require("mods")
local dhConf = mods.requireFromPlugin("../dhconfig")

local drawableSprite = require("structs.drawable_sprite")
local drawableRectangle = require("structs.drawable_rectangle")

local staminaGate = {}

staminaGate.name = "DaxHelper/staminaGate"
staminaGate.depth = 8998
staminaGate.texture = "objects/DaxHelper/staminaGate/skull00"
staminaGate.justification = {0, 0}

staminaGate.fieldInformation = {
    colour = { fieldType = "color" }
}

staminaGate.placements = {
    name = "normal",
    data = {
        width = 16,
        height = 16,
        colour = "ffaa33",
        DHVersion = dhConf.version
    }
}

function staminaGate.sprite(room, entity)
    local x, y = entity.x or 0, entity.y or 0
    local width, height = entity.width or 16, entity.height or 16

    local sprites = {}

    local col = entity.colour or "ffffff"
    local rect = drawableRectangle.fromRectangle(
        "fill",
        x, y, width, height,
        col
    )

    table.insert(sprites, rect:getDrawableSprite())

    local spr = drawableSprite.fromTexture(staminaGate.texture, entity)
    spr:setJustification(0.5, 0.5)
    spr:addPosition(width / 2, height / 2)

    table.insert(sprites, spr)

    return sprites
end

function staminaGate.selection(room, entity)
    return utils.rectangle(entity.x, entity.y, entity.width, entity.height)
end

return staminaGate
