#!/bin/perl

use v5.36;
use List::Util qw(min max);
use Convert::Color;

binmode STDOUT;

print pack 'a*LSSLLSSSS',
	'BM',   # file format
	12314,  # file size
	0,      # reserved
	0,      # reserved
	26,     # data offset
	12,     # DIB header size
	256,    # width
	16,     # height
	1,      # color planes
	24;     # bits per pixel

for my $G (reverse 0..15) {
	for my $B (0..15) {
		for my $R (0..15) {
			my ($r, $g, $b) = ($R * 17, $G * 17, $B * 17);
			my ($h, $s, $l) = Convert::Color->new("rgb8:$r,$g,$b")->as_hsl->hsl;
			$s = min(sqrt($s), 2*$s);
			print pack 'CCC', reverse Convert::Color->new("hsl:$h,$s,$l")->as_rgb8->rgb8;
		}
	}
}
