local drawableSprite = require("structs.drawable_sprite")
local utils = require("utils")

local lantern_switch = {}

local COLOR_PARTICLE_A_DEFAULT = "e3bf70"
local COLOR_PARTICLE_B_DEFAULT = "e48b52"
local COLOR_GLOW_DEFAULT = "e3bf70"

lantern_switch.name = "lantern/lantern_switch"

lantern_switch.placements = {
    {
        name = "up",
        data = {
            persistent = false,
            alwaysFlag = false,
            ceiling = false,
            rightSide = false,
            horizontal = false,
            particleColorA = COLOR_PARTICLE_A_DEFAULT,
            particleColorB = COLOR_PARTICLE_B_DEFAULT,
            glowColor = COLOR_GLOW_DEFAULT
        }
    },
    {
        name = "down",
        data = {
            persistent = false,
            alwaysFlag = false,
            ceiling = true,
            rightSide = false,
            horizontal = false,
            particleColorA = COLOR_PARTICLE_A_DEFAULT,
            particleColorB = COLOR_PARTICLE_B_DEFAULT,
            glowColor = COLOR_GLOW_DEFAULT
        }
    },
    {
        name = "left",
        data = {
            persistent = false,
            alwaysFlag = false,
            ceiling = false,
            rightSide = false,
            horizontal = true,
            particleColorA = COLOR_PARTICLE_A_DEFAULT,
            particleColorB = COLOR_PARTICLE_B_DEFAULT,
            glowColor = COLOR_GLOW_DEFAULT
        }
    },
    {
        name = "right",
        data = {
            persistent = false,
            alwaysFlag = false,
            ceiling = false,
            rightSide = true,
            horizontal = true,
            particleColorA = COLOR_PARTICLE_A_DEFAULT,
            particleColorB = COLOR_PARTICLE_B_DEFAULT,
            glowColor = COLOR_GLOW_DEFAULT
        }
    },
}

lantern_switch.fieldOrder = {"x", "y", "particleColorA", "particleColorB", "glowColor", "horizontal", "rightSide", "ceiling", "persistent", "alwaysFlag"}

lantern_switch.fieldInformation = {
    particleColorA = {
        fieldType = "color"
    },
    particleColorB = {
        fieldType = "color"
    },
    glowColor = {
        fieldType = "color"
    }
}

function lantern_switch.sprite(room, entity)
    local texture = "lantern/lantern_switch/empty0"
    local sprite = drawableSprite.fromTexture(texture, entity)
    sprite:setJustification(0.5, 1)

    if entity.horizontal then
        if entity.rightSide then
            sprite:addPosition(10, 18)
            sprite:setScale(-1, 1)
        else
            sprite:addPosition(-2, 18)
        end
    else
        if entity.ceiling then
            sprite:addPosition(18, 10)
            sprite.rotation = -math.pi / 2
        else
            sprite:addPosition(-2, -2)
            sprite.rotation = math.pi / 2
        end
    end

    return sprite
end

function lantern_switch.selection(room, entity)
    if entity.horizontal then
        if entity.rightSide then
            return utils.rectangle(entity.x, entity.y - 2, 13, 20)
        else
            return utils.rectangle(entity.x - 5, entity.y - 2, 13, 20)
        end
    else
        if entity.ceiling then
            return utils.rectangle(entity.x - 2, entity.y, 20, 13)
        else
            return utils.rectangle(entity.x - 2, entity.y - 5, 20, 13)
        end
    end
end

return lantern_switch
