module LanternLanternSwitch

using ..Ahorn, Maple

@mapdef Entity "Lantern/lantern_switch" LanternSwitch(x::Integer, y::Integer, rightSide::Bool=false, ceiling::Bool=false, persistent::Bool=false, horizontal::Bool=true, alwaysFlag::Bool=false, particleColorA::String="e3bf70", particleColorB::String="e48b52", glowColor::String="e3bf70")

const placements = Ahorn.PlacementDict()

directions = Dict{String, Tuple{Bool, String, Bool}}(
    "up" => (false, "ceiling", false),
    "down" => (false, "ceiling", true),
    "left" => (true, "rightSide", false),
    "right" => (true, "rightSide", true),
)

for (dir, data) in directions
    key = "Lantern Switch ($(uppercasefirst(dir))) (Lantern)"
    horiz, datakey, val = data
    placements[key] = Ahorn.EntityPlacement(
        LanternSwitch,
        "rectangle",
        Dict{String, Any}(
            "horizontal" => horiz,
            datakey => val
        )
    )
end

function Ahorn.selection(entity::LanternSwitch)
    x, y = Ahorn.position(entity)
    if get(entity.data, "horizontal", true)
        left = get(entity.data, "rightSide", false)

        if left
            return Ahorn.Rectangle(x, y - 1, 10, 16)

        else
            return Ahorn.Rectangle(x - 2, y, 10, 16)
        end
    else
        ceiling = get(entity.data, "ceiling", false)

        if ceiling
            return Ahorn.Rectangle(x, y, 16, 12)

        else
            return Ahorn.Rectangle(x, y - 4, 16, 12)
        end
    end
end

function Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::LanternySwitch, room::Maple.Room)
    texture = "lantern/lantern_switch/insert8"
    if get(entity.data, "horizontal", true)
        right = get(entity.data, "rightSide", false)

        if right
            Ahorn.drawSprite(ctx, texture, 30, 28, rot=pi)

        else
            Ahorn.drawSprite(ctx, texture, -2, 8)
        end
    else
        ceiling = get(entity.data, "ceiling", false)

        if ceiling
            Ahorn.drawSprite(ctx, texture, 8, 30, rot=-pi / 2)

        else
            Ahorn.drawSprite(ctx, texture, 28, -2, rot=pi / 2)
        end
    end
end

end
