local PlayerInventory = require("#celeste.PlayerInventory")

local vector2 = require("#microsoft.xna.framework.vector2")

local function fromRoom(x,y)
    return engine.Scene.LevelOffset + vector2(x, y)
end

local coroutineEntity = monocle.Entity()

local badeline

function onBegin()
    if not getFlag("busWatched") then
        disableMovement()
        engine.Scene:add(coroutineEntity)
        coroutineEntity:add(monocle.Coroutine(getLevel():ZoomTo(vector2(168, 106), 1.5, 1.5)))
        coroutineEntity:add(monocle.Coroutine(walkTo(180, false, 0.5)))
        player.Depth = 1000000000
        celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("paint_player"):PlayAnimation("paint_sit")
        wait(1)
        player.DummyAutoAnimate = false
        say("SJ2021_1_PAINT_AGAINST_THE_CURRENT_1")
        --baddy appear
        badeline = celeste.BadelineDummy(vector2(player.Position.X + 6, player.Position.Y - 7))
        badeline.Floatness = 0
        engine.Scene:add(badeline)
        local returnDepth = badeline.Depth
        badeline.Depth = 1000000
        badeline:Appear(getLevel(), true)
        badeline.Sprite:Play("pretendDead")
        celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("paint_player"):PlayAnimation("paint_busSitTogether")
        wait(0.5)
        say("SJ2021_1_PAINT_AGAINST_THE_CURRENT_2")
        badeline.Depth = returnDepth
        playSound("event:/char/badeline/grab", player.Position)
        badeline.Sprite:Play("hug")
        celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("paint_player"):PlayAnimation("paint_sitting")
        wait(1)
        say("SJ2021_1_PAINT_AGAINST_THE_CURRENT_3")
        wait(.4)
        celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("paint_player"):PlayAnimation("paint_unsit")
        coroutine.yield(badeline:FloatTo(vector2(player.Position.X + 12, player.Position.Y - 10), -1, false))
        wait(0.4)
        player.Depth = 0
        player.DummyAutoAnimate = true
        coroutine.yield(badeline:FloatTo(vector2(player.Position.X + 1, player.Position.Y - 5), 1, false))
        badeline:RemoveSelf()
        engine.Scene.Displacement:AddBurst(player.Position, 0.5, 24, 96, 0.4)
        player:CreateSplitParticles()
        getLevel().Session.Inventory = PlayerInventory.TheSummit
        coroutine.yield(getLevel():ZoomBack(2))
        enableMovement()
        setFlag("busWatched", true)
    end
end

function onEnd(level, wasSkipped)
    if wasSkipped then
        teleportTo(fromRoom(176,152))
        player.DummyAutoAnimate = true
        enableMovement()
        getLevel():ZoomBack(0)
        celeste.Mod.MaxHelpingHand.Entities.MoreCustomNPC.GetNPC("paint_player"):PlayAnimation("empty")
        player.Depth = 0
        getLevel().Session.Inventory = PlayerInventory.TheSummit
        setFlag("busWatched", true)
        if badeline then
            badeline:RemoveSelf()
        end
    end
end