local info = debug.getinfo(1)
local source = info.source
local parts = string.split(source, "/")()

local libPrefix = table.concat(parts, "/", 1, 2)
return {
    __themeName = "WindowsXp",
    iconsPath = "ui/themes/light/icons/",
    labelFontSize = 16,
    labelFilename = string.format([[%s/windows-xp-tahoma.ttf]], libPrefix),
    horizontalLine = {
        color = {0.4823, 0.6274, 0.9098, 1}
    },
    button = {
        disabledBG = {0.4, 0.4, 0.4, 0.7},
        disabledBorder = {0, 0, 0, 0, 1},
        disabledFG = {0, 0, 0, 0.7},
        hoveredBG = {1, 1, 1, 1},
        hoveredBorder = {0, 0.2235, 0.4313, 1, 1},
        hoveredFG = {0, 0, 0, 1},
        normalBG = {0.9490, 0.9490, 0.9411, 1},
        normalBorder = {0, 0.2235, 0.4313, 1, 1},
        normalFG = {0, 0, 0, 1},
        pressedBG = {0.1, 0.3, 0.6, 1},
        pressedBorder = {0.1, 0.3, 0.6, 1, 1},
        pressedFG = {1, 1, 1, 1}
    },
    buttonClose = {
        hoveredBG = {0.3607, 0.1568, 0.0784, 0.9},
        normalBG = {0.2745, 0.1960, 0.2196, 0.4},
        pressedBG = {0.6, 0.08, 0.14, 1}
    },
    buttonGreen = {
        hoveredBG = {0.7, 0.9, 0.7, 0.9},
        normalBG = {0.5, 0.8, 0.5, 0.8},
        pressedBG = {0.5, 0.9, 0.5, 0.9}
    },
    default = {},
    dropdown = {},
    field = {
        disabledBG = {0.5, 0.5, 0.5, 0.7},
        disabledBorder = {0, 0, 0, 0.7, 1},
        disabledFG = {0, 0, 0, 0.7, 0},
        focusedBG = {1, 1, 1, 0.9},
        focusedBorder = {0, 0, 0, 0.9, 1},
        focusedFG = {0, 0, 0, 0.9, 1},
        normalBG = {0.95, 0.95, 0.95, 0.9},
        normalBorder = {0.08, 0.08, 0.08, 0.6, 1},
        normalFG = {0, 0, 0, 0.8, 0}
    },
    group = {
        bg = {},
        border = {},
        radius = 0
    },
    icon = {
        color = {0, 0, 0, 1}
    },
    image = {
        color = {1, 1, 1, 1}
    },
    label = {
        color = {0, 0, 0, 1}
    },
    list = {
        dragLineColor = {0.2, 0.2, 0.2, 1.0}
    },
    listItem = {
        disabledBG = {0.4, 0.4, 0.4, 0.9},
        disabledBorder = {0, 0, 0, 0, 1},
        disabledFG = {0, 0, 0, 0.7},
        hoveredBG = {1, 1, 1, 1},
        hoveredBorder = {0, 0.2235, 0.4313, 1, 1},
        hoveredFG = {0, 0, 0, 1},
        normalBG = {0.9490, 0.9490, 0.9411, 1},
        normalBorder = {0, 0.2235, 0.4313, 1, 1},
        normalFG = {0, 0, 0, 1},
        pressedBG = {0.1, 0.3, 0.6, 1},
        pressedBorder = {0.1, 0.3, 0.6, 1, 1},
        pressedFG = {1, 1, 1, 1},
        radius = 0,
        selectedBG = {0.2235, 0.5019, 0.9568, 1},
        selectedBorder = {0.2235, 0.5019, 0.9568, 1, 1},
        selectedFG = {1, 1, 1, 1}
    },
    listItemGreen = {
        hoveredBG = {0.7, 0.9, 0.7, 0.9},
        normalBG = {0.5, 0.8, 0.5, 0.8},
        pressedBG = {0.1, 0.6, 0.1, 0.9},
        selectedBG = {0.2, 0.7, 0.2, 0.9}
    },
    listItemYellow = {
        hoveredBG = {0.9, 0.8, 0.4, 0.9},
        normalBG = {0.8, 0.7, 0.3, 0.8},
        pressedBG = {0.3, 0.2, 0, 0.9},
        selectedBG = {0.4, 0.3, 0.1, 0.9}
    },
    menuItem = {
        bg = {0.08, 0.08, 0.08, 0.8}
    },
    menuItemSubmenu = {
        bg = {0.08, 0.08, 0.08, 0.8}
    },
    panel = {
        bg = {0.8274, 0.8980, 0.9803, 0.85},
        border = {0.1490, 0.3843, 0.8745, 1},
        radius = 3
    },
    scrollbox = {},
    scrollhandle = {
        border = {},
        color = {},
        hoveredBorder = {0.6, 0.6, 0.6, 0.7, 1},
        hoveredColor = {0.6, 0.6, 0.6, 1},
        normalBorder = {0.5, 0.5, 0.5, 1, 1},
        normalColor = {0.5, 0.5, 0.5, 0.6},
        pressedBorder = {0.55, 0.55, 0.55, 0.7, 1},
        pressedColor = {0.55, 0.55, 0.55, 1},
        radius = 3,
        thickness = 6
    },
    scrollhandleX = {},
    scrollhandleY = {},
    spinner = {
        color = {0, 0, 0, 1}
    },
    titlebar = {
        border = {0.2235, 0.5019, 0.9568, 1},
        focusedBG = {0.2235, 0.5019, 0.9568, 1},
        focusedFG = {1, 1, 1, 1},
        radius = 0,
        unfocusedBG = {0.4823, 0.6274, 0.9098, 1},
        unfocusedFG = {1, 1, 1, 0.7}
    },
    topbar = {
        bg = {0.2235, 0.5019, 0.9568, 1},
        radius = 0
    },
    window = {
        bg = {1, 1, 1, 1},
        border = {0.2549, 0.4362, 0.7843, 1}
    }
}