local info = debug.getinfo(1)
local source = info.source
local parts = string.split(source, "/")()

local libPrefix = table.concat(parts, "/", 1, 2)
return {
    __themeName = "WindowsXpOlivefontless",
    iconsPath = "ui/themes/light/icons/",
    horizontalLine = {
        color = {0.8509, 0.8588, 0.7411, 1}
    },
    button = {
        disabledBG = {0.4, 0.4, 0.4, 0.7},
        disabledBorder = {0, 0, 0, 0, 1},
        disabledFG = {0, 0, 0, 0.7},
        hoveredBG = {1, 1, 1, 1},
        hoveredBorder = {0.4862, 0.4901, 0.3764, 1, 1},
        hoveredFG = {0, 0, 0, 1},
        normalBG = {0.9686, 0.9568, 0.8901, 1},
        normalBorder = {0.4862, 0.4901, 0.3764, 1, 1},
        normalFG = {0, 0, 0, 1},
        pressedBG = {0.6117, 0.6509, 0.4039, 1},
        pressedBorder = {0.6117, 0.6509, 0.4039, 1, 1},
        pressedFG = {1, 1, 1, 1}
    },
    buttonClose = {
        hoveredBG = {0.3607, 0.1568, 0.0784, 0.9},
        normalBG = {0.2745, 0.1960, 0.2196, 0.4},
        pressedBG = {0.6, 0.08, 0.14, 1}
    },
    buttonGreen = {
        hoveredBG = {0.7, 0.9, 0.7, 0.9},
        normalBG = {0.5, 0.8, 0.5, 0.8},
        pressedBG = {0.5, 0.9, 0.5, 0.9}
    },
    default = {},
    dropdown = {},
    field = {
        disabledBG = {0.5, 0.5, 0.5, 0.7},
        disabledBorder = {0, 0, 0, 0.7, 1},
        disabledFG = {0, 0, 0, 0.7, 0},
        focusedBG = {1, 1, 1, 0.9},
        focusedBorder = {0, 0, 0, 0.9, 1},
        focusedFG = {0, 0, 0, 0.9, 1},
        normalBG = {0.95, 0.95, 0.95, 0.9},
        normalBorder = {0.08, 0.08, 0.08, 0.6, 1},
        normalFG = {0, 0, 0, 0.8, 0}
    },
    group = {
        bg = {},
        border = {},
        radius = 0
    },
    icon = {
        color = {0, 0, 0, 1}
    },
    image = {
        color = {1, 1, 1, 1}
    },
    label = {
        color = {0, 0, 0, 1}
    },
    list = {
        dragLineColor = {0.2, 0.2, 0.2, 1.0}
    },
    listItem = {
        disabledBG = {0.4, 0.4, 0.4, 0.9},
        disabledBorder = {0, 0, 0, 0, 1},
        disabledFG = {0, 0, 0, 0.7},
        hoveredBG = {1, 1, 1, 1},
        hoveredBorder = {0.4862, 0.4901, 0.3764, 1, 1},
        hoveredFG = {0, 0, 0, 1},
        normalBG = {0.9686, 0.9568, 0.8901, 1},
        normalBorder = {0.4862, 0.4901, 0.3764, 1, 1},
        normalFG = {0, 0, 0, 1},
        pressedBG = {0.6117, 0.6509, 0.4039, 1},
        pressedBorder = {0.6117, 0.6509, 0.4039, 1, 1},
        pressedFG = {1, 1, 1, 1},
        radius = 0,
        selectedBG = {0.6823, 0.7137, 0.5215, 1},
        selectedBorder = {0.6823, 0.7137, 0.5215, 1, 1},
        selectedFG = {1, 1, 1, 1}
    },
    listItemGreen = {
        hoveredBG = {0.7, 0.9, 0.7, 0.9},
        normalBG = {0.5, 0.8, 0.5, 0.8},
        pressedBG = {0.1, 0.6, 0.1, 0.9},
        selectedBG = {0.2, 0.7, 0.2, 0.9}
    },
    listItemYellow = {
        hoveredBG = {0.9, 0.8, 0.4, 0.9},
        normalBG = {0.8, 0.7, 0.3, 0.8},
        pressedBG = {0.3, 0.2, 0, 0.9},
        selectedBG = {0.4, 0.3, 0.1, 0.9}
    },
    menuItem = {
        bg = {0.08, 0.08, 0.08, 0.8}
    },
    menuItemSubmenu = {
        bg = {0.08, 0.08, 0.08, 0.8}
    },
    panel = {
        bg = {0.9015, 0.8898, 0.8231, 1},
        border = {0.7411, 0.7647, 0.6705, 1},
        radius = 3
    },
    scrollbox = {},
    scrollhandle = {
        border = {},
        color = {},
        hoveredBorder = {0.6, 0.6, 0.6, 0.7, 1},
        hoveredColor = {0.6, 0.6, 0.6, 1},
        normalBorder = {0.5, 0.5, 0.5, 1, 1},
        normalColor = {0.5, 0.5, 0.5, 0.6},
        pressedBorder = {0.55, 0.55, 0.55, 0.7, 1},
        pressedColor = {0.55, 0.55, 0.55, 1},
        radius = 3,
        thickness = 6
    },
    scrollhandleX = {},
    scrollhandleY = {},
    spinner = {
        color = {0, 0, 0, 1}
    },
    titlebar = {
        border = {0.2235, 0.5019, 0.9568, 0},
        focusedBG = {0.6823, 0.7137, 0.5215, 1},
        focusedFG = {1, 1, 1, 1},
        radius = 0,
        unfocusedBG = {0.8509, 0.8588, 0.7411, 1},
        unfocusedFG = {1, 1, 1, 0.7}
    },
    topbar = {
        bg = {0.6823, 0.7137, 0.5215, 1},
        radius = 0
    },
    window = {
        bg = {0.9215, 0.9098, 0.8431, 1},
        border = {0.7411, 0.7647, 0.6705, 1}
    }
}