local info = debug.getinfo(1)
local source = info.source
local parts = string.split(source, "/")()

local libPrefix = table.concat(parts, "/", 1, 2)

return {
    __themeName = "ULTRAKILLfontless",
    horizontalLine = {
        color = {0.7, 0.7, 0.7, 1.0}
    },
    button = {
        disabledBG = {0.0588, 0.0588, 0.0588, 0.8235},
        disabledBorder = {0.0588, 0.0588, 0.0588, 0.8235, 2},
        disabledFG = {0.7, 0.7, 0.7, 0.7},
        hoveredBG = {0.0588, 0.0588, 0.0588, 0.8235},
        hoveredBorder = {0.5, 0.5, 0.5, 1, 2},
        hoveredFG = {1, 1, 1, 1},
        normalBG = {0.0588, 0.0588, 0.0588, 0.8235},
        normalBorder = {1, 1, 1, 1, 2},
        normalFG = {1, 1, 1, 1},
        pressedBG = {0.8901, 0.0196, 0.0196, 1},
        pressedBorder = {0.8901, 0.0196, 0.0196, 1, 2},
        pressedFG = {0, 0, 0, 1}
    },
    buttonClose = {
        hoveredBG = {0.85, 0.25, 0.25, 1},
        normalBG = {0.9, 0.1, 0.2, 0.8},
        pressedBG = {0.6, 0.08, 0.14, 1}
    },
    buttonGreen = {
        hoveredBG = {0.7, 0.9, 0.7, 0.9},
        normalBG = {0.5, 0.8, 0.5, 0.8},
        pressedBG = {0.5, 0.9, 0.5, 0.9}
    },
    default = {},
    dropdown = {},
    field = {
        disabledBG = {0.5, 0.5, 0.5, 0.7},
        disabledBorder = {0, 0, 0, 0.7, 2},
        disabledFG = {0, 0, 0, 0.7, 0},
        focusedBG = {1, 1, 1, 0.9},
        focusedBorder = {0, 0, 0, 0.9, 2},
        focusedFG = {0, 0, 0, 0.9, 1},
        normalBG = {0.95, 0.95, 0.95, 0.9},
        normalBorder = {0.08, 0.08, 0.08, 0.6, 2},
        normalFG = {0, 0, 0, 0.8, 0}
    },
    group = {
        bg = {},
        border = {},
        radius = 0
    },
    icon = {
        color = {1, 1, 1, 1}
    },
    image = {
        color = {1, 1, 1, 1}
    },
    label = {
        color = {1, 1, 1, 1}
    },
    list = {
        dragLineColor = {0.2, 0.2, 0.2, 1.0}
    },
    listItem = {
        disabledBG = {0.0588, 0.0588, 0.0588, 0.8235},
        disabledBorder = {0.0588, 0.0588, 0.0588, 0.8235, 1},
        disabledFG = {0.7, 0.7, 0.7, 0.7},
        hoveredBG = {0.0588, 0.0588, 0.0588, 0.8235},
        hoveredBorder = {0.5, 0.5, 0.5, 1, 2},
        hoveredFG = {1, 1, 1, 1},
        normalBG = {0.0588, 0.0588, 0.0588, 0.8235},
        normalBorder = {1, 1, 1, 1, 2},
        normalFG = {1, 1, 1, 1},
        pressedBG = {0.8901, 0.0196, 0.0196, 1},
        pressedBorder = {0.8901, 0.0196, 0.0196, 1, 0},
        pressedFG = {0, 0, 0, 1},
        radius = 0,
        selectedBG = {0.8901, 0.0196, 0.0196, 1},
        selectedBorder = {0.8901, 0.0196, 0.0196, 1, 0},
        selectedFG = {1, 1, 1, 1}
    },
    listItemGreen = {
        hoveredBG = {0.7, 0.9, 0.7, 0.9},
        normalBG = {0.5, 0.8, 0.5, 0.8},
        pressedBG = {0.1, 0.6, 0.1, 0.9},
        selectedBG = {0.2, 0.7, 0.2, 0.9}
    },
    listItemYellow = {
        hoveredBG = {0.9, 0.8, 0.4, 0.9},
        normalBG = {0.8, 0.7, 0.3, 0.8},
        pressedBG = {0.3, 0.2, 0, 0.9},
        selectedBG = {0.4, 0.3, 0.1, 0.9}
    },
    menuItem = {
        bg = {0.08, 0.08, 0.08, 0.8}
    },
    menuItemSubmenu = {
        bg = {0.08, 0.08, 0.08, 0.8}
    },
    panel = {
        bg = {0.0705, 0.0705, 0.0705, 0.97},
        border = {1, 1, 1, 1},
        radius = 3
    },
    scrollbox = {},
    scrollhandle = {
        border = {},
        color = {},
        hoveredBorder = {0.6, 0.6, 0.6, 0.7, 1},
        hoveredColor = {0.6, 0.6, 0.6, 1},
        normalBorder = {0.5, 0.5, 0.5, 1, 1},
        normalColor = {0.5, 0.5, 0.5, 0.6},
        pressedBorder = {0.55, 0.55, 0.55, 0.7, 1},
        pressedColor = {0.55, 0.55, 0.55, 1},
        radius = 3,
        thickness = 6
    },
    scrollhandleX = {},
    scrollhandleY = {},
    spinner = {
        color = {0, 0, 0, 1}
    },
    titlebar = {
        border = {0, 0, 0, 0},
        focusedBG = {0.7803, 0.6627, 0.0705, 1},
        focusedFG = {0, 0, 0, 1},
        radius = 0,
        unfocusedBG = {0.7603, 0.6427, 0.0505, 0.9},
        unfocusedFG = {0.1, 0.1, 0.1, 0.7}
    },
    topbar = {
        bg = {0.7803, 0.6627, 0.0705, 1},
        radius = 0
    },
    window = {
        bg = {0.0705, 0.0705, 0.0705, 0.97},
        border = {1, 1, 1, 1}
    }
}