
local drawableSprite = require("structs.drawable_sprite")

local diamondBerry = {}

local styles = {"Vanilla Styling by Strawbpixel", "Sleek Styling by Nerferd"}

diamondBerry.fieldInformation = {
    style = {
        options = styles,
        editable = false
    }
}

diamondBerry.name = "DiamondBerry/DiamondBerry"
diamondBerry.placements = {
    name = "Diamond Berry",
    data = {
        style = "Vanilla Styling by Strawbpixel",
        collectAudioPath = "event:/diamond_berry_normal",
        collectAudio1UpPath = "event:/diamond_berry_1_up"
    }
}

local textures = {"objects/DiamondBerry/monster_dberry/goldberry/idle00", "objects/DiamondBerry/nerf_dberry/goldberry/gemberry00"}

function diamondBerry.sprite(room, entity)
    --if this gets used for something more complicated it should be updated but this is fine as is since this is unlikely
    local sprites = {}
    local texture = textures[1]
    if (entity.style == styles[2]) then
        texture = textures[2]
    end
    sprite = drawableSprite.fromTexture(texture, {x = entity.x, y = entity.y, atlas = atlas})
    table.insert(sprites, sprite)
    return sprites
end

return diamondBerry
