--[[waitTillPlayerGrounded
playerWalkTo 512 1.3
playerJump 40 left true
playerWalkTo 400 1.3
wait 0.6
playerWalk 5 1
wait 0.6
playerWalk -5 1
wait 0.6
say RM_puzzlestart

ifSkipped:
setPlayerPos 400 456 false

]]--

local function playerJump(xspeed, timer)
    player.DummyFriction = false
    player.DummyAutoAnimate = true
    player.Speed.X = xspeed
    player:Jump()
    player.AutoJump = true
    player.AutoJumpTimer = timer
end

function onBegin()
    if not getFlag("run_once") then
        setFlag("run_once", true)
        disableMovement()
        player.ForceCameraUpdate = true
        coroutine.yield(player:DummyWalkTo(getRoomCoordinatesOffset(512, 0).X, false, 1.3, false))
        playerJump(40, 2)
        waitUntilOnGround()
        player.DummyFriction = true
        coroutine.yield(player:DummyWalkTo(getRoomCoordinatesOffset(400, 0).X, false, 1.3, false))
        wait(0.6)
        player.Facing = celeste.Facings.Right
        wait(0.6)
        player.Facing = celeste.Facings.Left
        wait(0.6)
        say("RM_puzzlestart")
        enableMovement()
        log(engine.Scene.Camera.Position)
    end
end

function onEnd(level, wasSkipped)
    if wasSkipped then
        enableMovement()
        setFlag("run_once", true)
        player.Position = getRoomCoordinatesOffset(400, 456)
        engine.Scene.Camera.Position = vector2(785, -1684)
    end
end