local vector2 = require("#microsoft.xna.framework.vector2")

local function dummyFloatTo(dummy, x, y)
    coroutine.yield(dummy:FloatTo(vector2(x, y)))
end

local coroutineEntityA = monocle.Entity()
local coroutineEntityB = monocle.Entity()
local coroutineEntityC = monocle.Entity()

local dummy = celeste.BadelineDummy(vector2(18372, -3720))

function onBegin()
    if not getFlag("CS_cutscene_2") then
        setFlag("CS_cutscene_2", true)
        disableMovement()
        waitUntilOnGround()
        player.ForceCameraUpdate = true
        engine.Scene:add(coroutineEntityA)
        engine.Scene:add(coroutineEntityB)
        engine.Scene:add(coroutineEntityC)

        walk(64, false, 1.4)
        coroutine.yield(jump(2))
        walk(56, false, 1.4)

        walkTo(18280, false, 1.4)
        coroutine.yield(jump(2))
        walk(48, false, 1.4)

        walkTo(18400, false, 1.4)
        
        engine.Scene:Add(dummy)

        coroutineEntityA:add(monocle.Coroutine(dummy:FloatTo(vector2(player.Position.X - 24, player.Position.Y - 8))))
        coroutineEntityB:add(monocle.Coroutine(walk(-5, false, 1)))
        coroutineEntityC:add(monocle.Coroutine(say("CS_battle")))


        wait(0.3)
        walk(5, false, 1)
        wait(0.3)
        say("CS_battleA")
        wait(0.3)
        walk(-5, false, 1)
        wait(0.3)
        say("CS_battleB")

        coroutineEntityA:add(monocle.Coroutine(dummy:FloatTo(vector2(18384, -3712))))
        coroutineEntityB:add(monocle.Coroutine(walkTo(18408, true, 1.3)))
        coroutineEntityC:add(monocle.Coroutine(say("CS_battleC")))

        walkTo(18416, true, 1.5)
        dummy:Vanish()

        enableMovement()
    end
end

function onEnd(level, wasSkipped)
    getLevel():remove(coroutineEntity)
    if wasSkipped then
        if dummy then
            dummy:RemoveSelf()
        end
        teleportTo(18411, -3712)
        enableMovement()
        getLevel():remove(coroutineEntityA)
        getLevel():remove(coroutineEntityB)
        getLevel():remove(coroutineEntityC)
        setFlag("CS_cutscene_2", true)
    end
end