local vector2 = require("#microsoft.xna.framework.vector2")
local calc = require("#Monocle.Calc")

local function dummyFloatTo(dummy, x, y)
    coroutine.yield(dummy:FloatTo(vector2(x, y)))
end

local dummy

function onBegin()
    if not getFlag("CS_cutscene_5") then
        setFlag("CS_cutscene_5", true)
        player.ForceCameraUpdate = true
        walk(240, false, 1.4, false)
        wait(0.4)
        run(24, true)
        say("CS_encounter")
        walk(-16, true, 1.4, false)
        wait(0.2)
        say("CS_encounterA")
        coroutine.yield(getLevel():ZoomTo(vector2(160, 110), 1.5, 2))
        walk(-24, false, 1, false)
        player.DummyAutoAnimate = false
        player.Sprite:Play("sitDown", true)
        wait(0.2)
        say("CS_encounterB")
        wait(0.5)
        say("CS_encounterC")
        wait(0.6)

        dummy = celeste.BadelineDummy(vector2(player.Position.X + 240, player.Position.Y - 8))
        playMusic("event:/new_content/music/lvl10/reconciliation")
        engine.Scene:Add(dummy)
        dummyFloatTo(dummy, player.Position.X + 80, player.Position.Y - 8)
        say("CS_appear")
        dummyFloatTo(dummy, player.Position.X + 40, player.Position.Y - 8)
        wait(0.2)
        say("CS_appearA")
        wait(0.3)
        dummyFloatTo(dummy, player.Position.X - 17, player.Position.Y - 5)
        wait(0.1)
        dummyFloatTo(dummy, player.Position.X - 16, player.Position.Y- 2)
        say("CS_appearB")
        wait(0.2)
        player.DummyAutoAnimate = false
        player.Sprite:Play("idle")
        wait(0.7)
        walk(25, false, 1.4, false)
        say("CS_appearC")

        walk(-5, false, 1, false)
        say("CS_appearD")
        dummyFloatTo(dummy, player.Position.X - 16, player.Position.Y - 2)
        say("CS_appearE")
        engine.Scene:NextColorGrade("oldsite")
        wait(0.7)
        say("CS_appearF")
        wait(0.5)
        engine.Scene:Flash(calc.HexToColor("ffffff"), false)
        wait(0.2)
        walk(5, false, 1, false)
        player.DummyAutoAnimate = false
        player.Sprite:Play("shaking", true)
        say("CS_continue")
        wait(0.3)
        engine.Scene:Flash(calc.HexToColor("ffffff"), false)
        wait(0.2)
        engine.Scene:Flash(calc.HexToColor("ffffff"), false)
        for _, entity in ipairs(getEntities("CrumbleWallOnRumble")) do
            entity:Break()
        end
    
        wait(0.3)
        player.DummyAutoAnimate = false
        player.Sprite:Play("idle")
        wait(0.4)
        say("CS_continueA")
        walk(-5, false, 1, false)
        say("CS_continueB")
        dummyFloatTo(dummy, player.Position.X + 25, player.Position.Y - 2)
        walk(5, false, 1, false)
        say("CS_continueC")
        walk(8, false, 1.4, false)
        wait(0.2)
        dummyFloatTo(dummy, player.Position.X + 16, player.Position.Y - 2)
        wait(0.1)
        say("CS_continueD")
        dummy:Vanish()
        coroutine.yield(getLevel():ZoomBack(2))

        player.DummyAutoAnimate = true
        enableMovement()
    end
end

function onEnd(level, wasSkipped)
    player.ForceCameraUpdate = true
    if wasSkipped then
        player.ForceCameraUpdate = true
        enableMovement()
        engine.Scene:SnapColorGrade("oldsite")
        player.DummyAutoAnimate = true
        setFlag("CS_cutscene_5", true)

        if dummy then
            dummy:RemoveSelf()
        end
        for _, entity in ipairs(getEntities("CrumbleWallOnRumble")) do
            entity:Break()
        end
        playMusic("event:/new_content/music/lvl10/reconciliation")
        coroutine.yield(getLevel():ZoomBack(0))
    end
end