local vector2 = require("#microsoft.xna.framework.vector2")

local function dummyFloatTo(dummy, x, y)
    coroutine.yield(dummy:FloatTo(vector2(x, y)))
end

local coroutineEntity = monocle.Entity()

local dummy = celeste.BadelineDummy(vector2(19154, -3760))

function onBegin()
    if not getFlag("CS_cutscene_3") then
        setFlag("CS_cutscene_3", true)
        player.ForceCameraUpdate = true
        disableMovement()
        engine.Scene:add(coroutineEntity)
        engine.Scene:Add(dummy)

        coroutineEntity:add(monocle.Coroutine(dummy:FloatTo(vector2(19304, -3760))))
        coroutineEntity:add(monocle.Coroutine(walk(-24, false, 1.4)))
        coroutineEntity:add(monocle.Coroutine(say("CS_barrier")))

        say("CS_barrierA")
        walkTo(19432, false, 1.5)
        coroutine.yield(jump(2))
        walk(56, false, 1.5)

        walkTo(19560, false, 1.5)
        coroutine.yield(jump(2))
        walk(56, false, 1.5)

        walkTo(19640, false, 1.2)
        playMusic("event:/Beyond Saturn's Rings")
        wait(0.1)
        player.DummyAutoAnimate = false
        player.Sprite:Play("tired", true)
        wait(0.3)
        say("CS_barrierB")
        wait(0.5)
        player.Sprite:Play("idle", true)
        player.DummyAutoAnimate = true
        wait(0.4)
        walk(-5, false, 1)
        say("CS_barrierC")
        dummy:RemoveSelf()

        enableMovement()
   end
end

function onEnd(level, wasSkipped)
    if wasSkipped then
        teleportTo(19640, -3776)
        enableMovement()
        player.DummyAutoAnimate = true
        playMusic("event:/Beyond Saturn's Rings")
        setFlag("CS_cutscene_3", true)
        if dummy then
            dummy:RemoveSelf()
        end
    end
end