local logging = require("logging")
local mods = require("mods")
local settings = mods.getModSettings("jsonmaps")
local mapcoder_json = mods.requireFromPlugin("libraries.mapcoder_json")

local mapcoder = require("mapcoder")
local loaded_state = require("loaded_state")
local filesystem = require("utils.filesystem")
local fileLocations = require("file_locations")
local filesystem = require("utils.filesystem")

--##

local old_encode = mapcoder.encodeFile
local old_decode = mapcoder.decodeFile
mapcoder.encodeFile = function(path, data, header)
	if settings.jsonmaps_doJsonExport then -- .saving and extension
        mapcoder_json.encodeFile(filesystem.stripExtension(filesystem.stripExtension(path))..".json", data, header)
    end

	return old_encode(path, data, header)
end
mapcoder.decodeFile = function(path, header)
	if path:sub(#path-4) == ".json" then 
        return mapcoder_json.decodeFile(path, header)
    end

	return old_decode(path, header)
end

local old_open = loaded_state.openMap
local old_save = loaded_state.saveFile
loaded_state.openMap = function()
    local targetDirectory = fileLocations.getCelesteDir()

    if loaded_state.filename and filesystem.isFile(loaded_state.filename) then
        targetDirectory = filesystem.dirname(loaded_state.filename)
    end

    filesystem.openDialog(targetDirectory, "bin,json", loaded_state.loadFile)
end
loaded_state.saveFile = function(filename, afterSaveCallback, beforeSaveCallback, addExtIfMissing, verifyMap)
    if filesystem.fileExtension(filename) == "json" then
        old_save(filesystem.stripExtension(filename)..".bin", afterSaveCallback, beforeSaveCallback, addExtIfMissing, verifyMap)
        addExtIfMissing=false
    end

    return old_save(filename, afterSaveCallback, beforeSaveCallback, addExtIfMissing, verifyMap)
end

--##

local menubar = require("ui.menubar").menubar
local viewMenu = $(menubar):find(menu -> menu[1] == "edit")[2]
if not $(viewMenu):find(item -> item[1] == "jsonmaps_doJsonExport") then
    table.insert(viewMenu,{
        "jsonmaps_doJsonExport",
        function() settings.jsonmaps_doJsonExport = not settings.jsonmaps_doJsonExport end,
        "checkbox",
        function() return settings.jsonmaps_doJsonExport or false end
    })
end

logging.info("[JsonMaps] loaded")
