﻿using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Monocle;
using System;
using System.Collections.Generic;
using System.IO;

namespace Celeste.Mod.Eevee_Skinmod {
    //this class has the function to make a palette from an image.
    public class EeveeColor {
        public static string toHex(Color color) {
            string hex = "#";
            byte[] bytes = new byte[] { color.R, color.G, color.B };
            hex += BitConverter.ToString(bytes).Replace("-", string.Empty);
            return hex;
        }
    }
    public class EeveeConverter {
        public static List<string> getNames(string path) {
            List<string> names = new List<string>();
            string[] files = Directory.GetFiles(path, "*.png"); 

            foreach (string str in files) {
                string filePath = str.Replace("\\", "/");
                string[] holder = (filePath.Substring(filePath.LastIndexOf("/") + 1)).Split('.');
                names.Add(holder[0]);
            }

            return names;
        }
        public static void convert(string path,string selection) {
            string filepath = (path + "\\" + selection + ".png");
            if (!File.Exists(@filepath)) {
                filepath = (path + "/" + selection + ".png");
            }
            Texture2D texture = Texture2D.FromStream(Engine.Graphics.GraphicsDevice, new FileStream(filepath, FileMode.Open));
            Color[] pixels = new Color[100*54];
            texture.GetData<Color>(pixels);
            Palette fluff = new Palette();

            fluff.ears1 = new List<string>();
            fluff.ears2 = new List<string>();
            fluff.ears3 = new List<string>();
            fluff.hair = new List<string>();
            fluff.fluff1 = new List<string>();
            fluff.fluff2 = new List<string>();
            fluff.tail1 = new List<string>();
            fluff.tail2 = new List<string>();
            fluff.tail3 = new List<string>();
            fluff.eyes = new List<string>();
            fluff.face1 = new List<string>();
            fluff.face2 = new List<string>();
            fluff.frontPaw1 = new List<string>();
            fluff.FrontPaw2 = new List<string>();
            fluff.backPaw1 = new List<string>();
            fluff.backPaw2 = new List<string>();
            fluff.frontPaw3 = new List<string>();
            fluff.frontPaw4 = new List<string>();
            fluff.backPaw3 = new List<string>();
            fluff.backPaw4 = new List<string>();
            fluff.body1 = new List<string>();
            fluff.body2 = new List<string>();
            fluff.tail4 = new List<string>();
            fluff.tail5 = new List<string>();
            fluff.body3 = new List<string>();
            fluff.body4 = new List<string>();
            fluff.dash = new List<string>();
            fluff.outline = new List<string>();
            fluff.mouth = new List<string>();

            fluff.ears1.Add(EeveeColor.toHex(pixels[0])); fluff.ears1.Add(EeveeColor.toHex(pixels[100*1])); fluff.ears1.Add(EeveeColor.toHex(pixels[100*2])); fluff.ears1.Add(EeveeColor.toHex(pixels[100 * 3])); fluff.ears1.Add(EeveeColor.toHex(pixels[100 * 4]));
            fluff.ears2.Add(EeveeColor.toHex(pixels[1])); fluff.ears2.Add(EeveeColor.toHex(pixels[1+100*1])); fluff.ears2.Add(EeveeColor.toHex(pixels[1+100 * 2])); fluff.ears2.Add(EeveeColor.toHex(pixels[1 + 100 * 3])); fluff.ears2.Add(EeveeColor.toHex(pixels[1 + 100 * 4]));
            fluff.ears3.Add(EeveeColor.toHex(pixels[2])); fluff.ears3.Add(EeveeColor.toHex(pixels[2 + 100 * 1])); fluff.ears3.Add(EeveeColor.toHex(pixels[2 + 100 * 2])); fluff.ears3.Add(EeveeColor.toHex(pixels[2 + 100 * 3])); fluff.ears3.Add(EeveeColor.toHex(pixels[2 + 100 * 4]));
            fluff.hair.Add(EeveeColor.toHex(pixels[3])); fluff.hair.Add(EeveeColor.toHex(pixels[3 + 100 * 1])); fluff.hair.Add(EeveeColor.toHex(pixels[3 + 100 * 2])); fluff.hair.Add(EeveeColor.toHex(pixels[3 + 100 * 3])); fluff.hair.Add(EeveeColor.toHex(pixels[3 + 100 * 4]));
            fluff.fluff1.Add(EeveeColor.toHex(pixels[4])); fluff.fluff1.Add(EeveeColor.toHex(pixels[4 + 100 * 1])); fluff.fluff1.Add(EeveeColor.toHex(pixels[4 + 100 * 2])); fluff.fluff1.Add(EeveeColor.toHex(pixels[4 + 100 * 3])); fluff.fluff1.Add(EeveeColor.toHex(pixels[4 + 100 * 4]));
            fluff.fluff2.Add(EeveeColor.toHex(pixels[5])); fluff.fluff2.Add(EeveeColor.toHex(pixels[5+100 * 1])); fluff.fluff2.Add(EeveeColor.toHex(pixels[5 + 100 * 2])); fluff.fluff2.Add(EeveeColor.toHex(pixels[5 + 100 * 3])); fluff.fluff2.Add(EeveeColor.toHex(pixels[5 + 100 * 4]));
            fluff.tail1.Add(EeveeColor.toHex(pixels[6])); fluff.tail1.Add(EeveeColor.toHex(pixels[6 + 100 * 1])); fluff.tail1.Add(EeveeColor.toHex(pixels[6 + 100 * 2])); fluff.tail1.Add(EeveeColor.toHex(pixels[6 + 100 * 3])); fluff.tail1.Add(EeveeColor.toHex(pixels[6 + 100 * 4]));
            fluff.tail2.Add(EeveeColor.toHex(pixels[7])); fluff.tail2.Add(EeveeColor.toHex(pixels[7 + 100 * 1])); fluff.tail2.Add(EeveeColor.toHex(pixels[7 + 100 * 2])); fluff.tail2.Add(EeveeColor.toHex(pixels[7 + 100 * 3])); fluff.tail2.Add(EeveeColor.toHex(pixels[7 + 100 * 4]));
            fluff.tail3.Add(EeveeColor.toHex(pixels[8])); fluff.tail3.Add(EeveeColor.toHex(pixels[8 + 100 * 1])); fluff.tail3.Add(EeveeColor.toHex(pixels[8 + 100 * 2])); fluff.tail3.Add(EeveeColor.toHex(pixels[8 + 100 * 3])); fluff.tail3.Add(EeveeColor.toHex(pixels[8 + 100 * 4]));
            fluff.eyes.Add(EeveeColor.toHex(pixels[9])); fluff.eyes.Add(EeveeColor.toHex(pixels[9 + 100 * 1])); fluff.eyes.Add(EeveeColor.toHex(pixels[9 + 100 * 2])); fluff.eyes.Add(EeveeColor.toHex(pixels[9 + 100 * 3])); fluff.eyes.Add(EeveeColor.toHex(pixels[9 + 100 * 4]));
            fluff.face1.Add(EeveeColor.toHex(pixels[10])); fluff.face1.Add(EeveeColor.toHex(pixels[10 + 100 * 1])); fluff.face1.Add(EeveeColor.toHex(pixels[10 + 100 * 2])); fluff.face1.Add(EeveeColor.toHex(pixels[10 + 100 * 3])); fluff.face1.Add(EeveeColor.toHex(pixels[10 + 100 * 4]));
            fluff.face2.Add(EeveeColor.toHex(pixels[11])); fluff.face2.Add(EeveeColor.toHex(pixels[11 + 100 * 1])); fluff.face2.Add(EeveeColor.toHex(pixels[11 + 100 * 2])); fluff.face2.Add(EeveeColor.toHex(pixels[11 + 100 * 3])); fluff.face2.Add(EeveeColor.toHex(pixels[11 + 100 * 4]));
            fluff.frontPaw1.Add(EeveeColor.toHex(pixels[12])); fluff.frontPaw1.Add(EeveeColor.toHex(pixels[12 + 100 * 1])); fluff.frontPaw1.Add(EeveeColor.toHex(pixels[12 + 100 * 2])); fluff.frontPaw1.Add(EeveeColor.toHex(pixels[12 + 100 * 3])); fluff.frontPaw1.Add(EeveeColor.toHex(pixels[12 + 100 * 4]));
            fluff.FrontPaw2.Add(EeveeColor.toHex(pixels[13])); fluff.FrontPaw2.Add(EeveeColor.toHex(pixels[13 + 100 * 1])); fluff.FrontPaw2.Add(EeveeColor.toHex(pixels[13 + 100 * 2])); fluff.FrontPaw2.Add(EeveeColor.toHex(pixels[13 + 100 * 3])); fluff.FrontPaw2.Add(EeveeColor.toHex(pixels[13 + 100 * 4]));
            fluff.backPaw1.Add(EeveeColor.toHex(pixels[14])); fluff.backPaw1.Add(EeveeColor.toHex(pixels[14 + 100 * 1])); fluff.backPaw1.Add(EeveeColor.toHex(pixels[14 + 100 * 2])); fluff.backPaw1.Add(EeveeColor.toHex(pixels[14 + 100 * 3])); fluff.backPaw1.Add(EeveeColor.toHex(pixels[14 + 100 * 4]));
            fluff.backPaw2.Add(EeveeColor.toHex(pixels[15])); fluff.backPaw2.Add(EeveeColor.toHex(pixels[15 + 100 * 1])); fluff.backPaw2.Add(EeveeColor.toHex(pixels[15 + 100 * 2])); fluff.backPaw2.Add(EeveeColor.toHex(pixels[15 + 100 * 3])); fluff.backPaw2.Add(EeveeColor.toHex(pixels[15 + 100 * 4]));
            fluff.frontPaw3.Add(EeveeColor.toHex(pixels[16])); fluff.frontPaw3.Add(EeveeColor.toHex(pixels[16 + 100 * 1])); fluff.frontPaw3.Add(EeveeColor.toHex(pixels[16 + 100 * 2])); fluff.frontPaw3.Add(EeveeColor.toHex(pixels[16 + 100 * 3])); fluff.frontPaw3.Add(EeveeColor.toHex(pixels[16 + 100 * 4]));
            fluff.frontPaw4.Add(EeveeColor.toHex(pixels[17])); fluff.frontPaw4.Add(EeveeColor.toHex(pixels[17 + 100 * 1])); fluff.frontPaw4.Add(EeveeColor.toHex(pixels[17 + 100 * 2])); fluff.frontPaw4.Add(EeveeColor.toHex(pixels[17 + 100 * 3])); fluff.frontPaw4.Add(EeveeColor.toHex(pixels[17 + 100 * 4]));
            fluff.backPaw3.Add(EeveeColor.toHex(pixels[18])); fluff.backPaw3.Add(EeveeColor.toHex(pixels[18 + 100 * 1])); fluff.backPaw3.Add(EeveeColor.toHex(pixels[18 + 100 * 2])); fluff.backPaw3.Add(EeveeColor.toHex(pixels[18 + 100 * 3])); fluff.backPaw3.Add(EeveeColor.toHex(pixels[18 + 100 * 4]));
            fluff.backPaw4.Add(EeveeColor.toHex(pixels[19])); fluff.backPaw4.Add(EeveeColor.toHex(pixels[19 + 100 * 1])); fluff.backPaw4.Add(EeveeColor.toHex(pixels[19 + 100 * 2])); fluff.backPaw4.Add(EeveeColor.toHex(pixels[19 + 100 * 3])); fluff.backPaw4.Add(EeveeColor.toHex(pixels[19 + 100 * 4]));
            fluff.body1.Add(EeveeColor.toHex(pixels[20])); fluff.body1.Add(EeveeColor.toHex(pixels[20 + 100 * 1])); fluff.body1.Add(EeveeColor.toHex(pixels[20 + 100 * 2])); fluff.body1.Add(EeveeColor.toHex(pixels[20 + 100 * 3])); fluff.body1.Add(EeveeColor.toHex(pixels[20 + 100 * 4]));
            fluff.body2.Add(EeveeColor.toHex(pixels[21])); fluff.body2.Add(EeveeColor.toHex(pixels[21 + 100 * 1])); fluff.body2.Add(EeveeColor.toHex(pixels[21 + 100 * 2])); fluff.body2.Add(EeveeColor.toHex(pixels[21 + 100 * 3])); fluff.body2.Add(EeveeColor.toHex(pixels[21 + 100 * 4]));
            fluff.tail4.Add(EeveeColor.toHex(pixels[22])); fluff.tail4.Add(EeveeColor.toHex(pixels[22 + 100 * 1])); fluff.tail4.Add(EeveeColor.toHex(pixels[22 + 100 * 2])); fluff.tail4.Add(EeveeColor.toHex(pixels[22 + 100 * 3])); fluff.tail4.Add(EeveeColor.toHex(pixels[22 + 100 * 4]));
            fluff.tail5.Add(EeveeColor.toHex(pixels[23])); fluff.tail5.Add(EeveeColor.toHex(pixels[23 + 100 * 1])); fluff.tail5.Add(EeveeColor.toHex(pixels[23 + 100 * 2])); fluff.tail5.Add(EeveeColor.toHex(pixels[23 + 100 * 3])); fluff.tail5.Add(EeveeColor.toHex(pixels[23 + 100 * 4]));
            fluff.body3.Add(EeveeColor.toHex(pixels[24])); fluff.body3.Add(EeveeColor.toHex(pixels[24 + 100 * 1])); fluff.body3.Add(EeveeColor.toHex(pixels[24 + 100 * 2])); fluff.body3.Add(EeveeColor.toHex(pixels[24 + 100 * 3])); fluff.body3.Add(EeveeColor.toHex(pixels[24 + 100 * 4]));
            fluff.body4.Add(EeveeColor.toHex(pixels[25])); fluff.body4.Add(EeveeColor.toHex(pixels[25 + 100 * 1])); fluff.body4.Add(EeveeColor.toHex(pixels[25 + 100 * 2])); fluff.body4.Add(EeveeColor.toHex(pixels[25 + 100 * 3])); fluff.body4.Add(EeveeColor.toHex(pixels[25 + 100 * 4]));
            fluff.dash.Add(EeveeColor.toHex(pixels[26])); fluff.dash.Add(EeveeColor.toHex(pixels[26 + 100 * 1])); fluff.dash.Add(EeveeColor.toHex(pixels[26 + 100 * 2])); fluff.dash.Add(EeveeColor.toHex(pixels[26 + 100 * 3])); fluff.dash.Add(EeveeColor.toHex(pixels[26 + 100 * 4]));
            fluff.outline.Add(EeveeColor.toHex(pixels[27])); fluff.outline.Add(EeveeColor.toHex(pixels[27 + 100 * 1])); fluff.outline.Add(EeveeColor.toHex(pixels[27 + 100 * 2])); fluff.outline.Add(EeveeColor.toHex(pixels[27 + 100 * 3])); fluff.outline.Add(EeveeColor.toHex(pixels[27 + 100 * 4]));
            fluff.mouth.Add(EeveeColor.toHex(pixels[28])); fluff.mouth.Add(EeveeColor.toHex(pixels[28 + 100 * 1])); fluff.mouth.Add(EeveeColor.toHex(pixels[28 + 100 * 2])); fluff.mouth.Add(EeveeColor.toHex(pixels[28 + 100 * 3])); fluff.mouth.Add(EeveeColor.toHex(pixels[28 + 100 * 4]));
            var writer = new YamlDotNet.Serialization.Serializer();
            string file = path + "\\" + selection+".yaml";
            if (File.Exists(@file)) {
                int i = 1;
                while (File.Exists(@file)) {
                    file = String.Format(path + "\\" + selection + "_({0}).yaml", i);
                    i++;
                }
            } else {
                file = path + "/" + selection + ".yaml";
                if (File.Exists(@file)) {
                    int i = 1;
                    while (File.Exists(@file)) {
                        file = String.Format(path + "/" + selection + "_({0}).yaml", i);
                        i++;
                    }
                }
            }
            StreamWriter sw = new StreamWriter(file);
            writer.Serialize(sw,fluff);

            sw.Close();

            //return fluff;
        }
    }
}
