﻿
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Monocle;
using System;



namespace Celeste.Mod.Eevee_Skinmod {
    public class ColorGradeManager {
        private Texture2D colorGradeNone;
        public Texture2D colorGrade;
        private Color[] pixels;
        public ColorGradeManager() {

            pixels = new Color[256 * 16];
            colorGradeNone = GFX.ColorGrades["none"].Texture.Texture_Safe;
            colorGrade = new Texture2D(Celeste.Instance.GraphicsDevice, 256, 16);
            colorGradeNone.GetData<Color>(pixels);
            colorGrade.SetData(pixels);

        }
        //This is the function for tinting the old colorgrade, unfortunately it messes up the red flashing animation
        //still better marginally that using the new shader, it breaks in some intances completely.
        //It should used procedureline tbh
        public void writeColor(SkinPalette fluffer, int dashes) {
            pixels[0] = fluffer.outline[dashes];
            pixels[1] = fluffer.outline[dashes];

            pixels[256 * 15] = fluffer.ears1[dashes];

            pixels[256 * 8] = fluffer.ears2[dashes];
            pixels[256 * 9] = fluffer.ears2[dashes];

            pixels[8 + 256 * 15] = fluffer.ears3[dashes];
            pixels[15 + 256 * 15] = fluffer.hair[dashes];

            pixels[103] = fluffer.fluff1[dashes];
            pixels[119] = fluffer.fluff1[dashes];

            pixels[96] = fluffer.fluff2[dashes];
            pixels[112] = fluffer.fluff2[dashes];

            pixels[159 + 256 * 8] = fluffer.tail1[dashes];
            pixels[159 + 256 * 9] = fluffer.tail1[dashes];
            pixels[175 + 256 * 8] = fluffer.tail1[dashes];
            pixels[175 + 256 * 9] = fluffer.tail1[dashes];

            pixels[151] = fluffer.tail2[dashes];
            pixels[152] = fluffer.tail2[dashes];
            pixels[167] = fluffer.tail2[dashes];
            pixels[168] = fluffer.tail2[dashes];

            pixels[240] = fluffer.tail3[dashes];
            pixels[8] = fluffer.eyes[dashes];
            pixels[15] = fluffer.face1[dashes];

            pixels[15 + 256 * 8] = fluffer.face2[dashes];
            pixels[15 + 256 * 9] = fluffer.face2[dashes];

            pixels[111] = fluffer.frontPaw1[dashes];
            pixels[127] = fluffer.frontPaw1[dashes];

            pixels[111 + 256 * 8] = fluffer.frontPaw2[dashes];
            pixels[111 + 256 * 9] = fluffer.frontPaw2[dashes];
            pixels[127 + 256 * 8] = fluffer.frontPaw2[dashes];
            pixels[127 + 256 * 9] = fluffer.frontPaw2[dashes];

            pixels[96 + 256 * 15] = fluffer.backPaw1[dashes];
            pixels[112 + 256 * 15] = fluffer.backPaw1[dashes];

            pixels[96 + 256 * 8] = fluffer.backPaw2[dashes];
            pixels[96 + 256 * 9] = fluffer.backPaw2[dashes];
            pixels[112 + 256 * 8] = fluffer.backPaw2[dashes];
            pixels[112 + 256 * 9] = fluffer.backPaw2[dashes];

            pixels[111 + 256 * 15] = fluffer.frontPaw3[dashes];
            pixels[127 + 256 * 15] = fluffer.frontPaw3[dashes];

            pixels[104 + 256 * 15] = fluffer.frontPaw4[dashes];
            pixels[120 + 256 * 15] = fluffer.frontPaw4[dashes];

            pixels[240 + 256 * 15] = fluffer.backPaw3[dashes];
            pixels[240 + 256 * 8] = fluffer.backPaw4[dashes];
            pixels[240 + 256 * 9] = fluffer.backPaw4[dashes];

            pixels[144] = fluffer.body1[dashes];
            pixels[160] = fluffer.body1[dashes];

            pixels[144 + 256 * 8] = fluffer.body2[dashes];
            pixels[144 + 256 * 9] = fluffer.body2[dashes];
            pixels[160 + 256 * 8] = fluffer.body2[dashes];
            pixels[160 + 256 * 9] = fluffer.body2[dashes];

            pixels[152 + 256 * 15] = fluffer.tail4[dashes];
            pixels[151 + 256 * 15] = fluffer.tail4[dashes];
            pixels[167 + 256 * 15] = fluffer.tail4[dashes];
            pixels[168 + 256 * 15] = fluffer.tail4[dashes];

            pixels[159 + 256 * 15] = fluffer.tail5[dashes];
            pixels[175 + 256 * 15] = fluffer.tail5[dashes];

            pixels[159] = fluffer.body3[dashes];
            pixels[175] = fluffer.body3[dashes];

            pixels[144 + 256 * 15] = fluffer.body4[dashes];
            pixels[160 + 256 * 15] = fluffer.body4[dashes];

            pixels[37 + 256 * 1] = fluffer.mouth[dashes];
            pixels[37 + 256 * 2] = fluffer.mouth[dashes];
            pixels[38 + 256 * 1] = fluffer.mouth[dashes];
            pixels[38 + 256 * 2] = fluffer.mouth[dashes];

            colorGrade.SetData(pixels);
        }

        public void writeColorNet(SkinPalette fluffer, int dashes) {
            pixels[0] = fluffer.outline[dashes];

            pixels[256 * 15] = fluffer.ears1[dashes];

            pixels[256 * 8] = fluffer.ears2[dashes];
            pixels[256 * 9] = fluffer.ears2[dashes];

            pixels[7 + 256 * 15] = fluffer.ears3[dashes];
            pixels[8 + 256 * 15] = fluffer.ears3[dashes];

            pixels[15 + 256 * 15] = fluffer.hair[dashes];

            pixels[103] = fluffer.fluff1[dashes];
            pixels[104] = fluffer.fluff1[dashes];

            pixels[95] = fluffer.fluff2[dashes];
            pixels[96 ] = fluffer.fluff2[dashes];

            pixels[159 + 256 * 8] = fluffer.tail1[dashes];
            pixels[159 + 256 * 9] = fluffer.tail1[dashes];
            pixels[160 + 256 * 8] = fluffer.tail1[dashes];
            pixels[160 + 256 * 9] = fluffer.tail1[dashes];

            pixels[151] = fluffer.tail2[dashes];
            pixels[152] = fluffer.tail2[dashes];

            pixels[240] = fluffer.tail3[dashes];
            pixels[7] = fluffer.eyes[dashes];
            pixels[8] = fluffer.eyes[dashes];
            pixels[15] = fluffer.face1[dashes];

            pixels[15 + 256 * 8] = fluffer.face2[dashes];
            pixels[15 + 256 * 9] = fluffer.face2[dashes];

            pixels[111] = fluffer.frontPaw1[dashes];
            pixels[112] = fluffer.frontPaw1[dashes];

            pixels[111 + 256 * 8] = fluffer.frontPaw2[dashes];
            pixels[111 + 256 * 9] = fluffer.frontPaw2[dashes];
            pixels[112 + 256 * 8] = fluffer.frontPaw2[dashes];
            pixels[112 + 256 * 9] = fluffer.frontPaw2[dashes];

            pixels[96 + 256 * 15] = fluffer.backPaw1[dashes];
            pixels[95 + 256 * 15] = fluffer.backPaw1[dashes];

            pixels[96 + 256 * 8] = fluffer.backPaw2[dashes];
            pixels[96 + 256 * 9] = fluffer.backPaw2[dashes];
            pixels[95 + 256 * 8] = fluffer.backPaw2[dashes];
            pixels[95 + 256 * 9] = fluffer.backPaw2[dashes];

            pixels[111 + 256 * 15] = fluffer.frontPaw3[dashes];
            pixels[112 + 256 * 15] = fluffer.frontPaw3[dashes];

            pixels[103 + 256 * 15] = fluffer.frontPaw4[dashes];
            pixels[104 + 256 * 15] = fluffer.frontPaw4[dashes];

            pixels[240 + 256 * 15] = fluffer.backPaw3[dashes];
            pixels[240 + 256 * 8] = fluffer.backPaw4[dashes];
            pixels[240 + 256 * 9] = fluffer.backPaw4[dashes];

            pixels[143] = fluffer.body1[dashes];
            pixels[144] = fluffer.body1[dashes];

            pixels[144 + 256 * 8] = fluffer.body2[dashes];
            pixels[144 + 256 * 9] = fluffer.body2[dashes];
            pixels[143 + 256 * 8] = fluffer.body2[dashes];
            pixels[143 + 256 * 9] = fluffer.body2[dashes];

            pixels[152 + 256 * 15] = fluffer.tail4[dashes];
            pixels[151 + 256 * 15] = fluffer.tail4[dashes];

            pixels[159 + 256 * 15] = fluffer.tail5[dashes];
            pixels[160 + 256 * 15] = fluffer.tail5[dashes];

            pixels[159] = fluffer.body3[dashes];
            pixels[160] = fluffer.body3[dashes];

            pixels[144 + 256 * 15] = fluffer.body4[dashes];
            pixels[143 + 256 * 15] = fluffer.body4[dashes];
            
            pixels[37 + 256 * 1] = fluffer.mouth[dashes];
            pixels[37 + 256 * 2] = fluffer.mouth[dashes];
            pixels[38 + 256 * 1] = fluffer.mouth[dashes];
            pixels[38 + 256 * 2] = fluffer.mouth[dashes];


            colorGrade.SetData(pixels);
        }
        //Same with this function
        
        public void CustomDash(Color dashColor) {
            pixels[103] = dashColor;
            pixels[119] = dashColor;

            pixels[159 + 256 * 8] = dashColor;
            pixels[159 + 256 * 9] = dashColor;
            pixels[175 + 256 * 8] = dashColor;
            pixels[175 + 256 * 9] = dashColor;

            Color DashAccent = dashColor;
            DashAccent.R = (Byte)(DashAccent.R > 50 ?  DashAccent.R - 50 : 0);
            DashAccent.G = (Byte)(DashAccent.G > 50 ? DashAccent.G - 50 : 0);
            DashAccent.B = (Byte)(DashAccent.B > 50 ? DashAccent.B - 50 : 0);

            pixels[96] = DashAccent;
            pixels[112] = DashAccent;

            pixels[151] = DashAccent;
            pixels[152] = DashAccent;
            pixels[167] = DashAccent;
            pixels[168] = DashAccent;

            Color DashDarkerAccent = dashColor;
            DashDarkerAccent.R = (Byte)(DashDarkerAccent.R > 100 ? DashDarkerAccent.R - 100 : 0);
            DashDarkerAccent.G = (Byte)(DashDarkerAccent.G > 100 ? DashDarkerAccent.G - 100 : 0);
            DashDarkerAccent.B = (Byte)(DashDarkerAccent.B > 100 ? DashDarkerAccent.B - 100 : 0);

            pixels[240] = DashDarkerAccent;

            colorGrade.SetData(pixels);
        }
        //Function related to the CelesteNet Shader, commented out since i had to use the old shader to reduce the times it breaks in game
        /*
        public void CustomDash(Color dashColor) {
            pixels[103] = dashColor;
            pixels[104] = dashColor;

            pixels[159 + 256 * 8] = dashColor;
            pixels[159 + 256 * 9] = dashColor;
            pixels[160 + 256 * 8] = dashColor;
            pixels[160 + 256 * 9] = dashColor;

            Color DashAccent = dashColor;
            DashAccent.R = (Byte)(DashAccent.R > 50 ? DashAccent.R - 50 : 0);
            DashAccent.G = (Byte)(DashAccent.G > 50 ? DashAccent.G - 50 : 0);
            DashAccent.B = (Byte)(DashAccent.B > 50 ? DashAccent.B - 50 : 0);

            pixels[95] = DashAccent;
            pixels[96] = DashAccent;

            pixels[151] = DashAccent;
            pixels[152] = DashAccent;

            Color DashDarkerAccent = dashColor;
            DashDarkerAccent.R = (Byte)(DashDarkerAccent.R > 100 ? DashDarkerAccent.R - 100 : 0);
            DashDarkerAccent.G = (Byte)(DashDarkerAccent.G > 100 ? DashDarkerAccent.G - 100 : 0);
            DashDarkerAccent.B = (Byte)(DashDarkerAccent.B > 100 ? DashDarkerAccent.B - 100 : 0);

            pixels[240] = DashDarkerAccent;

            colorGrade.SetData(pixels);
        }
        */
    }

}
