#define DECLARE_TEXTURE(Name, index) \
    texture Name: register(t##index); \
    sampler Name##Sampler: register(s##index)

#define SAMPLE_TEXTURE(Name, texCoord) tex2D(Name##Sampler, texCoord)

uniform float Time; // level.TimeActive
uniform float2 CamPos; // level.Camera.Position
uniform float2 Dimensions; // new Vector2(320, 180)

uniform float4x4 TransformMatrix;
uniform float4x4 ViewMatrix;

DECLARE_TEXTURE(text, 0);

float fixed_sine(float x) {
    return (sin(x) + 1.0) / 2.0;
}

float waver(float x) {
    float sin2 = sin(x / 2.0) * sin(x / 2.0);
    return 1.0 - sin2 * sin2;
}

float4 SpritePixelShader(float2 uv : TEXCOORD0) : COLOR0
{
    float2 worldPos = (uv * Dimensions) + CamPos / 2;
    float4 color = SAMPLE_TEXTURE(text, uv);
    
    float3 c = float3(0.3, 0.1, 0.15);
    float4 v = fixed_sine(worldPos.x / 13.0 + sin(worldPos.y / 5.0 + Time) * 10.0 + sin(Time) * sin(worldPos.x / 8.0 + Time * 3.0 + 1.0)) + waver(worldPos.x / 100.0 - worldPos.y / 100.0 + Time * 4.0 + 3.1415 / 2.0);
    

    return float4(c.rgb * v - 0.35 + color, 1.0);
}

void SpriteVertexShader(inout float4 color    : COLOR0,
                        inout float2 texCoord : TEXCOORD0,
                        inout float4 position : SV_Position)
{
    position = mul(position, ViewMatrix);
    position = mul(position, TransformMatrix);
}

technique Shader
{
    pass pass0
    {
        VertexShader = compile vs_3_0 SpriteVertexShader();
        PixelShader = compile ps_3_0 SpritePixelShader();
    }
}