local drawableSprite = require("structs.drawable_sprite")

local obj = {}

obj.name = "ArphimigonsDSides/FinaleChain"
obj.depth = 100
obj.minimumSize = {16, 16}
obj.placements = {
    name = "Finale Chain (Arphimigon's D-Sides After-Story)",
    data = {
        height = 24
    }
}

function obj.sprite(room, entity)
    local x, y = entity.x or 0, entity.y or 0
    local height = entity.height or 8

    local linkHeight = 16
    local linkIntendedCount = height / linkHeight

    local linkImages = {}
    for i = 0,linkIntendedCount-1 do
        local chainSprite = drawableSprite.fromTexture("decals/arphimigon/chain_link", entity)
        chainSprite:addPosition(4, math.floor(i * linkHeight))
        table.insert(linkImages, chainSprite)
    end
    return linkImages
end

return obj