﻿using System;
using System.Threading;
using System.Threading.Tasks;

namespace Celeste.Mod.CelesteButtplug;

public static class TaskFunctions
{
    public static async Task WaitWhile(Func<bool> condition, Action whileDelegate = null, int frequency = 25, int timeout = -1, CancellationToken cancellationToken = default)
    {
        bool result = condition();
        while (result)
        {
            if(whileDelegate != null) await Task.Run(whileDelegate, cancellationToken);
            if (cancellationToken.IsCancellationRequested)
            {
                Logger.Debug(nameof(CelesteButtplugModule), "Task cancelled");
                break;
            }
            await Task.Delay(frequency, cancellationToken);
            if (cancellationToken.IsCancellationRequested)
            {
                Logger.Debug(nameof(CelesteButtplugModule), "Task cancelled");
                break;
            }
            result = condition();
        }
    }
}