﻿using System.Linq;
using System.Threading.Tasks;

namespace Celeste.Mod.CelesteButtplug.Settings;

[SettingSubMenu]
public class TriggerSubMenu
{
    public bool Enabled { get; set; } = false;
    [SettingSubText("Requires CelesteNet to be enabled.")]
    public bool Multiplayer { get; set; }
    public void CreateMultiplayerEntry(TextMenuExt.SubMenu menu, bool inGame)
    {
    }

    [SettingSubText("Look at https://easings.net/")]
    public EasingFunction EasingCurve { get; set; }
        
    public bool OverrideGlobalMillis { get; set; }
    [SettingRange(min: 1, max: 2000, largeRange: true)]
    public int Millis { get; set; } = 1000;
    public bool OverrideGlobalStrength { get; set; }
    [SettingRange(min: 0, max: 100, largeRange: true)]
    public int Strength { get; set; }

    public int GetFinalStrength()
    {
        return OverrideGlobalStrength ? Strength : CelesteButtplugModule.Settings.Strength;
    }

    public int GetFinalMillis()
    {
        return OverrideGlobalMillis ? Millis : CelesteButtplugModule.Settings.Millis;
    }
    
    public void Buzz()
    {
        if(!Enabled) return;
        Logger.Debug(nameof(CelesteButtplugModule),
            "Trigger for " + CelesteButtplugModule.Settings.GetType().GetProperties()
                .First(info => info.GetValue(CelesteButtplugModule.Settings) == this).Name);
        
        Task.WhenAll(CelesteButtplugModule.Manager.Devices().Select(async device => await CelesteButtplugModule.Manager.TriggerBuzzAsync(device, this)));
    }
}