﻿using System.Linq;
using System.Threading.Tasks;

namespace Celeste.Mod.CelesteButtplug.Settings.Multiplayer;

[SettingSubMenu]
public abstract class MultiplayerTriggerSubMenu : TriggerSubMenu
{
    public new void CreateMultiplayerEntry(TextMenuExt.SubMenu menu, bool inGame)
    {
        bool compatible = CelesteButtplugModule.MultiplayerHooksManager.IsCompatible;
        bool enabled = compatible && Multiplayer;
        TextMenu.OnOff multiplayerEntry = new(
            label: "Multiplayer activated",
            on: enabled
        )
        {
            Disabled = !compatible,
        };
        menu.Add(multiplayerEntry);
        Logger.Debug(nameof(CelesteButtplugModule),
            "Added multiplayer option for " + CelesteButtplugModule.Settings.GetType().GetProperties()
                .First(info => info.GetValue(CelesteButtplugModule.Settings) == this).Name + " (state: " + enabled + ")");

        multiplayerEntry.Change(newValue =>
        {
            Multiplayer = newValue;
            if (Multiplayer)
            {
                OnEnabled();
            }
            else
            {
                OnDisabled();
            }
        });
    }
    
    internal abstract void OnEnabled();
    internal abstract void OnDisabled();
    
    public void Buzz(bool multiplayer)
    {
        if(!Enabled) return;
        if (!multiplayer)
        {
            Buzz();
            return;
        }
        if (!Multiplayer) return;
        Logger.Debug(nameof(CelesteButtplugModule),
            "Trigger for " + CelesteButtplugModule.Settings.GetType().GetProperties()
                .First(info => info.GetValue(CelesteButtplugModule.Settings) == this).Name + " (Multiplayer)");
        
        Task.WhenAll(CelesteButtplugModule.Manager.Devices().Select(async device => await CelesteButtplugModule.Manager.TriggerBuzzAsync(device, this)));
    }
}