﻿using Microsoft.Xna.Framework;

namespace Celeste.Mod.CelesteButtplug;

public static class Events
{
    public static void Unregister()
    {
        On.Celeste.Player.Die -= OnPlayerOnDie;
        On.Celeste.Player.DashEnd -= OnPlayerDashEnd;
        On.Celeste.Player.Jump -= OnJump;
        On.Celeste.Player.ClimbJump -= OnClimbJump;
        On.Celeste.Player.WallJump -= OnWallJump;
        On.Celeste.Player.ClimbHop -= OnClimbHop;
        On.Celeste.Player.Update -= OnSquish;
        On.Celeste.Player.Pickup -= OnPickup;
        On.Celeste.Player.Throw -= OnThrow;
        On.Celeste.Player.ClimbBegin -= OnClimbBegin;
        On.Celeste.Player.ClimbUpdate -= OnClimb;
        On.Celeste.Player.OnTransition -= OnScreenTransition;
        On.Celeste.Strawberry.OnCollect -= StrawberryOnCollect;
    }

    public static void Register()
    {
        On.Celeste.Player.Die += OnPlayerOnDie;
        On.Celeste.Player.DashEnd += OnPlayerDashEnd;
        On.Celeste.Player.Jump += OnJump;
        On.Celeste.Player.ClimbJump += OnClimbJump;
        On.Celeste.Player.WallJump += OnWallJump;
        On.Celeste.Player.ClimbHop += OnClimbHop;
        On.Celeste.Player.Update += OnSquish;
        On.Celeste.Player.Pickup += OnPickup;
        On.Celeste.Player.Throw += OnThrow;
        On.Celeste.Player.ClimbBegin += OnClimbBegin;
        On.Celeste.Player.ClimbUpdate += OnClimb;
        On.Celeste.Player.OnTransition += OnScreenTransition;
        On.Celeste.Strawberry.OnCollect += StrawberryOnCollect;
    }

    private static Vector2 _prevPosition = Vector2.Zero;
    private static bool _prevDucking;

    private static PlayerDeadBody OnPlayerOnDie(On.Celeste.Player.orig_Die orig, Player self, Vector2 direction, bool invincible, bool stats)
    {
        if (invincible) return orig(self, direction, invincible, stats);
        CelesteButtplugModule.Settings.OnDie.Buzz();
        return orig(self, direction, invincible, stats);
    }

    private static void OnPlayerDashEnd(On.Celeste.Player.orig_DashEnd orig, Player self)
    {
        CelesteButtplugModule.Settings.OnDash.Buzz();
        orig(self);
    }

    private static void OnJump(On.Celeste.Player.orig_Jump orig, Player self, bool particles, bool playsfx)
    {
        CelesteButtplugModule.Settings.OnJump.Buzz();
        orig(self, particles, playsfx);
    }

    private static void OnClimbJump(On.Celeste.Player.orig_ClimbJump orig, Player self)
    {
        CelesteButtplugModule.Settings.OnJump.Buzz();
        orig(self);
    }
    
    private static void OnWallJump(On.Celeste.Player.orig_WallJump orig, Player self, int dir)
    {
        CelesteButtplugModule.Settings.OnJump.Buzz();
        orig(self, dir);
    }

    private static void OnClimbHop(On.Celeste.Player.orig_ClimbHop orig, Player self)
    {
        CelesteButtplugModule.Settings.OnJump.Buzz();
        orig(self);
    }

    private static void OnSquish(On.Celeste.Player.orig_Update orig, Player self)
    {
        if (self.Ducking != _prevDucking)
        {
            if(self.Ducking) CelesteButtplugModule.Settings.OnSqueesh.Buzz();
            _prevDucking = self.Ducking;
        }
        orig(self);
    }

    private static bool OnPickup(On.Celeste.Player.orig_Pickup orig, Player self, Holdable pickup)
    {
        CelesteButtplugModule.Settings.OnPickup.Buzz();
        return orig(self, pickup);
    }

    private static void OnThrow(On.Celeste.Player.orig_Throw orig, Player self)
    {
        CelesteButtplugModule.Settings.OnThrow.Buzz();
        orig(self);
    }

    private static void OnClimbBegin(On.Celeste.Player.orig_ClimbBegin orig, Player self)
    {
        _prevPosition = self.Position;
        CelesteButtplugModule.Settings.WhileClimbing.Buzz();
        orig(self);
    }

    private static int OnClimb(On.Celeste.Player.orig_ClimbUpdate orig, Player self)
    {
        // ReSharper disable once InvertIf
        if (self.Position != _prevPosition)
        {
            CelesteButtplugModule.Settings.WhileClimbing.Buzz();
            _prevPosition = self.Position;
        }
        return orig(self);
    }

    private static void OnScreenTransition(On.Celeste.Player.orig_OnTransition orig, Player self)
    {
        CelesteButtplugModule.Settings.OnScreenTransition.Buzz();
        orig(self);
    }

    private static void StrawberryOnCollect(On.Celeste.Strawberry.orig_OnCollect orig, Strawberry self)
    {
        CelesteButtplugModule.Settings.OnBerryCollected.Buzz();
        orig(self);
    }
}