﻿using System;
using System.Collections.Generic;
using System.Linq;
using Celeste.Mod.CelesteButtplug.Managers;
using Celeste.Mod.CelesteButtplug.Settings;
using Celeste.Mod.CelesteButtplug.Settings.Multiplayer;

namespace Celeste.Mod.CelesteButtplug;

public class CelesteButtplugModule : EverestModule {
    private static CelesteButtplugModule Instance { get; set; }

    public override Type SettingsType => typeof(CelesteButtplugModuleSettings);
    public static CelesteButtplugModuleSettings Settings => (CelesteButtplugModuleSettings) Instance._Settings;

    public override Type SessionType => typeof(CelesteButtplugModuleSession);
    public static CelesteButtplugModuleSession Session => (CelesteButtplugModuleSession) Instance._Session;

    public override Type SaveDataType => typeof(CelesteButtplugModuleSaveData);
    public static CelesteButtplugModuleSaveData SaveData => (CelesteButtplugModuleSaveData)Instance._SaveData;

    public static ButtplugClientManager Manager { get; private set; }
    public static MultiplayerHooksManager MultiplayerHooksManager { get; } = new();

    public CelesteButtplugModule() {
        Instance = this;
#if DEBUG
        // debug builds use verbose logging
        Logger.SetLogLevel(nameof(CelesteButtplugModule), LogLevel.Verbose);
#else
        // release builds use info logging to reduce spam in log files
        Logger.SetLogLevel(nameof(CelesteButtplugModule), LogLevel.Info);
#endif
    }

    public override async void Load()
    {
        Manager = new ButtplugClientManager(Settings);
        await Manager.TryReconnect();
        Events.Register();
        MultiplayerHooksManager.Register();
        
        IEnumerable<MultiplayerTriggerSubMenu> subMenus = Settings.GetType().GetProperties()
            .Where(info => info.GetType().IsSubclassOf(typeof(MultiplayerTriggerSubMenu)))
            .Select(info => (MultiplayerTriggerSubMenu) info.GetValue(Settings));
        foreach (MultiplayerTriggerSubMenu subMenu in subMenus)
        {
            if (subMenu is not { Multiplayer: true }) continue;
            subMenu.OnEnabled();
        }
    }

    public override async void Unload() {
        await Manager.Disconnect();
        Events.Unregister();
        MultiplayerHooksManager.Unregister();
        
        IEnumerable<MultiplayerTriggerSubMenu> subMenus = Settings.GetType().GetProperties()
            .Where(info => info.GetType().IsSubclassOf(typeof(MultiplayerTriggerSubMenu)))
            .Select(info => (MultiplayerTriggerSubMenu) info.GetValue(Settings));
        foreach (MultiplayerTriggerSubMenu subMenu in subMenus)
        {
            if (subMenu is not { Multiplayer: true }) continue;
            subMenu.OnDisabled();
        }
    }
}