#!/usr/bin/env bash

origdress1="#64C8FF"
origdress2="#59B4E5"
origdress3="#4FA0CC"
origclip="#21B1FF"

dress1="#5B6EE1"
dress2="#4D57AB"
dress3="#3F3F74"
clip="#21B1FF"

mkdir -p edited
find . -type f -iname '*.png' | while read -r img; do
	out="edited/${img#./}"	# Preserve subfolder structure
	mkdir -p "$(dirname "$out")"
	convert "$img" \
		-fuzz 0% -fill "$dress1" -opaque "$origdress1" \
		-fuzz 0% -fill "$dress2" -opaque "$origdress2" \
		-fuzz 0% -fill "$dress3" -opaque "$origdress3" \
		-fuzz 0% -transparent "$origclip" \
	"$out"
done
