
-- store the badeline entity outside the functions, so it can be accessed whenever necessary
local badeline = nil

local function badeline_appears(right_side)
  -- determine the position and flipping properties
  local pos_x, scale
  if right_side then
    pos_x = player.Position.X - 18
    scale = 1
  else
    pos_x = player.Position.X + 18
    scale = -1
  end
  local pos_y = player.Position.Y - 8
  walkTo(-6829, false, 1.2)
  -- create and add a new badeline dummy entity
  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale.X = scale
  getLevel():Add(badeline)

  -- play sound + effect
  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  -- wait until the next frame so all that can take effect properly
  wait()
  local luanet = _G.luanet
  player.Facing = luanet.enum(luanet.import_type("Celeste.Facings"), "Right")
  player.ForceCameraUpdate = false
  say("BetterTimesDia5")
  wait(0.3)
  coroutine.yield(getLevel():ZoomTo(vector2(168, 102), 1.3, 0.6))
  say("BetterTimesDia5A")
  setFlag("blueGlassHeartSol", true)
  playSound("event:/game/06_reflection/hug_levelup_text_in", player.Position)
  wait(0.3)
  say("BetterTimesDia5B")
  playSound("event:/game/06_reflection/hug_levelup_text_in", player.Position)
  setFlag("redGlassHeartSol", true)
  wait(0.25)
  say("BetterTimesDia5C")
  playSound("event:/game/06_reflection/hug_levelup_text_in", player.Position)
  setFlag("yellowGlassHeartSol", true)
  wait(0.1)
  say("BetterTimesDia5D")
  wait(0.2)
  setFlag("blueGlassHeartSol", false)
  playSound("event:/game/general/diamond_touch", player.Position)
  wait(0.15)
  setFlag("redGlassHeartSol", false)
  playSound("event:/new_content/game/10_farewell/pinkdiamond_touch", player.Position)
  wait(0.2)
  setFlag("yellowGlassHeartSol", false)
  playSound("event:/game/general/diamond_touch", player.Position)
  wait(1)
  say("BetterTimesDia5E")
  wait(0.1)
  coroutine.yield(getLevel():ZoomAcross(vector2(168, 106), 1.7, 0.6))
  say("BetterTimesDia5F")
  playSound("event:/game/general/diamond_return", player.Position)
  setFlag("BIGblueGlassHeartSol", true)
  wait(0.5)
  say("BetterTimesDia5G")
  playSound("event:/new_content/game/10_farewell/pinkdiamond_return", player.Position)
  setFlag("BIGredGlassHeartSol", true)
  wait(0.5)
  say("BetterTimesDia5H")
  playSound("event:/game/general/diamond_return", player.Position)
  setFlag("BIGyellowGlassHeartSol", true)
  wait(0.5)
  say("BetterTimesDia5I")
  playSound("event:/new_content/game/10_farewell/pinkdiamond_return", player.Position)
  setFlag("BIGgreenGlassHeartSol", true)
  wait(0.5)
  say("BetterTimesDia5J")
  playSound("event:/game/general/diamond_return", player.Position)
  setFlag("BIGpinkGlassHeartSol", true)
  wait(0.5)
  say("BetterTimesDia5K")
  playSound("event:/new_content/game/10_farewell/pinkdiamond_return", player.Position)
  setFlag("BIGpurpleGlassHeartSol", true)
  wait(0.5)
  say("BetterTimesDia5L") 
  playSound("event:/game/06_reflection/hug_badeline_glow", player.Position)
  setFlag("BIGblackGlassHeartSol", true)
  wait(0.5)
  coroutine.yield(engine.Scene:ZoomBack(0.95))
  say("BetterTimesDia5M")


end

local function badeline_vanishes()
  -- tell the badeline entity to disappear
  badeline:Vanish()
  Input.Rumble(getEnum("Celeste.RumbleStrength", "Medium"), getEnum("Celeste.RumbleLength", "Medium"))
  -- clear the stored variable so the memory can be used for something else
  badeline = nil

  -- wait until the next frame
  wait()
end

function onBegin(room)
  disableMovement()
  badeline_appears()
  badeline_vanishes()
end

function onEnd(room, wasSkipped)
  setFlag("blueGlassHeartSol", false)
  setFlag("redGlassHeartSol", false)
  setFlag("yellowGlassHeartSol", false)
  getLevel():ResetZoom()
  if badeline then
    badeline:RemoveSelf()
    badeline = nil
  end
  enableMovement()
end