-- Code from microlith and bit
local vector2 = require("#microsoft.xna.framework.vector2")
local monocle = require("#monocle")
local cor = monocle.Entity()

local function summonJade(position)
    jade = celeste.NPC(position)
    getRoom():Add(jade)
    local sprite = celeste.GFX.SpriteBank:Create("jade")
    jade:Add(sprite)
    jade.Sprite = sprite
    sprite:Play("idle")
    jade.IdleAnim = "idle"
    jade.MoveAnim = "walk"
    jade.Maxspeed = 58
    jade.MoveY = true
end

local function moveJade(xVector,yVector)
  coroutine.yield(jade:MoveTo(jade.Position + vector2(xVector, yVector)))
end

function onBegin()
  disablePause()
  summonJade(vector2(9600, -3368))
  enablePause()
if not (getFlag("sumDone")) then
  setFlag("summitGlitchA", false)
  disableMovement()
  moveJade(-1, -16)
  local level = getLevel()
  -- Zoom to 40 pixels below the center of the screen
  coroutine.yield(level:ZoomTo(vector2(160, 90), 1.5, 0.5))
  --player.DummyAutoAnimate = false
  say("SunkenMountain_Summit")
  coroutine.yield(level:ZoomTo(vector2(160, 90), 0.0001, 7))
  say("SunkenMountain_Flashback")
  coroutine.yield(level:ZoomAcross(vector2(160, 90), 1, 0.5))
  say("SunkenMountain_SummitB")
  playSound("event:/new_content/game/10_farewell/glitch_medium");
  setFlag("summitGlitchA", true)
  say("SunkenMountain_SummitC")
  enableMovement()
  end
end


function onEnd(room, wasSkipped)
  setFlag("sumDone", true)
  playSound("event:/new_content/game/10_farewell/glitch_medium");
  setFlag("summitGlitchA", true)
jade.Visible = false
  enableMovement()
end