-- Code from microlith and bit
local vector2 = require("#microsoft.xna.framework.vector2")
local monocle = require("#monocle")
local cor = monocle.Entity()

local function summonJade(position)
    jade = celeste.NPC(position)
    getRoom():Add(jade)
    local sprite = celeste.GFX.SpriteBank:Create("jade")
    jade:Add(sprite)
    jade.Sprite = sprite
    sprite:Play("idle")
    jade.IdleAnim = "idle"
    jade.MoveAnim = "walk"
    jade.Maxspeed = 58
    jade.MoveY = true
end

local function moveJade(xVector,yVector)
  coroutine.yield(jade:MoveTo(jade.Position + vector2(xVector, yVector)))
end

function onBegin()
if not (getFlag("houseDone")) then
  disableMovement()
  disablePause()
  summonJade(vector2(3688, -608))
  enablePause()
  moveJade(-68, 0)
  moveJade(-40, 40)
  moveJade(-112, 0)
  local level = getLevel()
  -- Zoom to 40 pixels below the center of the screen
  coroutine.yield(level:ZoomTo(vector2(130, 90), 1.5, 0.5))
  --player.DummyAutoAnimate = false
  say("SunkenMountain_JadeFirstMeeting")
  coroutine.yield(celeste.CutsceneEntity.CameraTo(vector2(3352, -784), 1))
  say("SunkenMountain_JadeFirstMeetingB")
  --level:ZoomBack(3)
  --level:ResetZoom()
 coroutine.yield(celeste.CutsceneEntity.CameraTo(vector2(3352, -684), 1))
 jade.Maxspeed = 10000
 jade.MoveAnim = "run"
 moveJade(112, 0)
 coroutine.yield(level:ZoomAcross(vector2(160, 90), 1, 0.5))
 enableMovement()
 moveJade(40, -40)
 moveJade(10000, 0)
 end
end


function onEnd(room, wasSkipped)
  setFlag("houseDone", true)
jade.Visible = false
  enableMovement()
end